/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.client.highlights.base.Highlight;
import com.teamresourceful.resourcefullib.client.highlights.base.HighlightLine;
import com.teamresourceful.resourcefullib.client.highlights.base.Highlightable;
import com.teamresourceful.resourcefullib.client.highlights.state.HighlightStates;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5699;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class HighlightHandler
extends class_4309<JsonElement> {
    private static final Reference2ReferenceMap<class_2680, float[]> STATE_CACHE = new Reference2ReferenceOpenHashMap();
    private static final Map<class_2960, Highlight> BOX_CACHE = new HashMap<class_2960, Highlight>();
    public static final Codec<Highlight> HIGHLIGHT_CODEC = class_2960.field_25139.xmap(HighlightHandler::getOrThrow, Highlight::id);

    public HighlightHandler() {
        super(class_5699.field_40721, class_7654.method_45114((String)"resourcefullib/highlights"));
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> jsons, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        BOX_CACHE.clear();
        STATE_CACHE.clear();
        HashMap<class_2960, JsonElement> highlights = new HashMap<class_2960, JsonElement>();
        HashMap<class_2960, JsonElement> blocks = new HashMap<class_2960, JsonElement>();
        jsons.forEach((key, json) -> (json.isJsonObject() && json.getAsJsonObject().has("lines") ? highlights : blocks).put(key, json));
        highlights.forEach((key, value) -> Highlight.codec(key).parse((DynamicOps)JsonOps.INSTANCE, value).result().ifPresent(box -> BOX_CACHE.put((class_2960)key, (Highlight)box)));
        HashMap cache = new HashMap();
        blocks.forEach((key, value) -> class_7923.field_41175.method_17966(key).flatMap(block -> HighlightStates.codec(block).parse((DynamicOps)JsonOps.INSTANCE, value).result()).ifPresent(variants -> variants.states().forEach((states, box) -> states.forEach(state -> {
            if (cache.containsKey(box)) {
                STATE_CACHE.put(state, (Object)((float[])cache.get(box)));
            } else {
                float[] lines = new float[box.lines().size() * 9];
                int i = 0;
                for (HighlightLine line : box.lines()) {
                    lines[i++] = line.start().x();
                    lines[i++] = line.start().y();
                    lines[i++] = line.start().z();
                    lines[i++] = line.end().x();
                    lines[i++] = line.end().y();
                    lines[i++] = line.end().z();
                    lines[i++] = line.normal().x();
                    lines[i++] = line.normal().y();
                    lines[i++] = line.normal().z();
                }
                STATE_CACHE.put(state, (Object)lines);
                cache.put(box, lines);
            }
        }))));
        BOX_CACHE.clear();
    }

    public static boolean onBlockHighlight(class_243 cameraPos, class_1297 cameraEntity, class_4587 stack, class_2338 blockPos, class_2680 state, class_4588 consumer, int color) {
        Highlightable highlightable;
        Highlight highlight;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof Highlightable && (highlight = (highlightable = (Highlightable)class_22482).getHighlight(cameraEntity.method_37908(), blockPos, state)) != null) {
            highlight.render(consumer, stack, cameraPos, state.method_26226(blockPos), blockPos);
            return true;
        }
        if (STATE_CACHE.containsKey((Object)state)) {
            class_243 offset = state.method_26226(blockPos);
            stack.method_22903();
            float x = (float)((double)blockPos.method_10263() - cameraPos.method_10216());
            float y = (float)((double)blockPos.method_10264() - cameraPos.method_10214());
            float z = (float)((double)blockPos.method_10260() - cameraPos.method_10215());
            x += (float)offset.method_10216();
            y += (float)offset.method_10214();
            z += (float)offset.method_10215();
            float[] lines = (float[])STATE_CACHE.get((Object)state);
            if (lines.length % 9 != 0) {
                return false;
            }
            for (int i = 0; i < lines.length; i += 9) {
                HighlightLine.render(stack, consumer, color, x, y, z, lines[i], lines[i + 1], lines[i + 2], lines[i + 3], lines[i + 4], lines[i + 5], lines[i + 6], lines[i + 7], lines[i + 8]);
            }
            stack.method_22909();
            return true;
        }
        return false;
    }

    private static Highlight getOrThrow(class_2960 id) {
        Highlight highlight = BOX_CACHE.get(id);
        if (highlight == null) {
            throw new RuntimeException("No highlight with the id '" + String.valueOf(id) + "' was found!");
        }
        return highlight;
    }
}

