/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights.base;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record HighlightLine(Vector3f start, Vector3f end, Vector3f normal) {
    public static final Codec<HighlightLine> CODEC = Codec.FLOAT.listOf().comapFlatMap(floats -> class_156.method_33141((List)floats, (int)6).map(HighlightLine::new), HighlightLine::getAsList);

    public HighlightLine(Vector3f start, Vector3f end) {
        this(start, end, HighlightLine.normal(start, end));
    }

    public HighlightLine(List<Float> list) {
        this(new Vector3f(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue()), new Vector3f(list.get(3).floatValue(), list.get(4).floatValue(), list.get(5).floatValue()));
    }

    public List<Float> getAsList() {
        return List.of(Float.valueOf(this.start.x()), Float.valueOf(this.start.y()), Float.valueOf(this.start.z()), Float.valueOf(this.end.x()), Float.valueOf(this.end.y()), Float.valueOf(this.end.z()));
    }

    public HighlightLine copy() {
        return new HighlightLine(new Vector3f((Vector3fc)this.start), new Vector3f((Vector3fc)this.end));
    }

    public void recalculateNormal() {
        Vector3f normal = HighlightLine.normal(this.start, this.end);
        this.normal.set(normal.x(), normal.y(), normal.z());
    }

    public void render(class_4587 poseStack, class_4588 consumer, float x, float y, float z) {
        HighlightLine.render(poseStack, consumer, 102, x, y, z, this.start.x(), this.start.y(), this.start.z(), this.end.x(), this.end.y(), this.end.z(), this.normal.x(), this.normal.y(), this.normal.z());
    }

    public static void render(class_4587 stack, class_4588 consumer, int color, float x, float y, float z, float x1, float y1, float z1, float x2, float y2, float z2, float normalX, float normalY, float normalZ) {
        class_4587.class_4665 last = stack.method_23760();
        consumer.method_22918(last.method_23761(), x + x1, y + y1, z + z1).method_39415(color).method_60831(last, normalX, normalY, normalZ);
        consumer.method_22918(last.method_23761(), x + x2, y + y2, z + z2).method_39415(color).method_60831(last, normalX, normalY, normalZ);
    }

    private static Vector3f normal(Vector3f start, Vector3f end) {
        Vector3f diff = new Vector3f(start.x() - end.x(), start.y() - end.y(), start.z() - end.z());
        float sqrt = class_3532.method_15355((float)(diff.x() * diff.x() + diff.y() * diff.y() + diff.z() * diff.z()));
        return new Vector3f(diff.x() / sqrt, diff.y() / sqrt, diff.z() / sqrt);
    }
}

