/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.handler;

import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.universalenchants.init.CompositeHolderSet;
import fuzs.universalenchants.init.ModRegistry;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_10192;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1820;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.class_9889;

public class ItemCompatHandler {
    public static final Set<class_9274> ARMOR_EQUIPMENT_SLOT_GROUPS = Set.of(class_9274.field_49220, class_9274.field_49221, class_9274.field_49222, class_9274.field_49223, class_9274.field_49224);
    static final ThreadLocal<class_3902> IS_BLOCKING_WITH_SHIELD = new ThreadLocal();

    public static void onFinalizeItemComponents(class_1792 item, Consumer<Function<class_9323, class_9326>> consumer) {
        if (item instanceof class_1820 || item instanceof class_1819) {
            consumer.accept(components -> class_9326.method_57841().method_57854(class_9334.field_53695, (Object)new class_9889(1)).method_57852());
        } else {
            consumer.accept(components -> {
                class_10192 equippable;
                if (!components.method_57832(class_9334.field_53695) && (equippable = (class_10192)components.method_58694(class_9334.field_54196)) != null && equippable.comp_3174() == class_1304.field_48824) {
                    class_9285 itemAttributeModifiers = (class_9285)components.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
                    double defenseValue = itemAttributeModifiers.comp_2393().stream().filter(entry -> entry.comp_2395().method_55838(class_5134.field_23724)).map(class_9285.class_9287::comp_2396).mapToDouble(class_1322::comp_2449).sum();
                    return class_9326.method_57841().method_57854(class_9334.field_53695, (Object)new class_9889(Math.max(1, class_3532.method_15384((double)defenseValue)))).method_57852();
                }
                return class_9326.field_49588;
            });
        }
    }

    public static void onTagsUpdated(class_7225.class_7874 registries, boolean client) {
        class_7225.class_7226 itemLookup = registries.method_46762(class_7924.field_41197);
        class_7225.class_7226 enchantmentLookup = registries.method_46762(class_7924.field_41265);
        enchantmentLookup.method_42017().forEach(holder -> {
            class_1887 enchantment = (class_1887)holder.comp_349();
            class_1887.class_9427 enchantmentDefinition = enchantment.comp_2687();
            if (!enchantmentDefinition.comp_2513().contains(class_9274.field_50127)) {
                for (class_9274 slot : enchantmentDefinition.comp_2513()) {
                    if (!ARMOR_EQUIPMENT_SLOT_GROUPS.contains(slot)) continue;
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll((Iterable)enchantmentDefinition.comp_2513());
                    builder.add((Object)class_9274.field_50127);
                    enchantmentDefinition.comp_2513 = builder.build();
                }
            }
            ItemCompatHandler.setEnchantmentProperty(enchantmentLookup, ModRegistry.getInclusiveSetEnchantmentTag((class_5321<class_1887>)holder.method_40237()), enchantment.comp_2688(), holderSet -> {
                enchantment.comp_2688 = holderSet;
            }, CompositeHolderSet.Removal::new);
            ItemCompatHandler.setSupportedEnchantmentItems(itemLookup, ModRegistry.getSecondaryEnchantableItemTag((class_5321<class_1887>)holder.method_40237()), enchantmentDefinition.comp_2506(), holderSet -> {
                enchantmentDefinition.comp_2506 = holderSet;
            });
            enchantmentDefinition.comp_2507().ifPresent(holderSetX -> ItemCompatHandler.setSupportedEnchantmentItems(itemLookup, ModRegistry.getPrimaryEnchantableItemTag((class_5321<class_1887>)holder.method_40237()), holderSetX, holderSet -> {
                enchantmentDefinition.comp_2507 = Optional.of(holderSet);
            }));
        });
    }

    private static <T> void setSupportedEnchantmentItems(class_7225.class_7226<T> registryLookup, class_6862<T> tagKey, class_6885<T> supportedItems, Consumer<class_6885<T>> holderSetSetter) {
        ItemCompatHandler.setEnchantmentProperty(registryLookup, tagKey, supportedItems, holderSetSetter, (o1, o2) -> new CompositeHolderSet.Or(List.of(o1, o2)));
    }

    private static <T> void setEnchantmentProperty(class_7225.class_7226<T> registryLookup, class_6862<T> tagKey, class_6885<T> originalHolderSet, Consumer<class_6885<T>> holderSetSetter, BinaryOperator<class_6885<T>> holderSetCombiner) {
        Optional optional = registryLookup.method_46733(tagKey);
        class_6885 newHolderSet = optional.map(holderSetX -> holderSetX).orElse(class_6885.method_58563());
        holderSetSetter.accept((class_6885)holderSetCombiner.apply(originalHolderSet, newHolderSet));
    }

    public static EventResult onShieldBlock(class_1309 blockingEntity, class_1282 damageSource, MutableFloat blockedDamage) {
        class_1937 class_19372 = blockingEntity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_1297 class_12972;
            class_3218 serverLevel = (class_3218)class_19372;
            if (damageSource.method_60489() && (class_12972 = damageSource.method_5529()) instanceof class_1309) {
                class_1309 attackingEntity = (class_1309)class_12972;
                if (IS_BLOCKING_WITH_SHIELD.get() == null) {
                    IS_BLOCKING_WITH_SHIELD.set(class_3902.field_17274);
                    class_1890.method_60619((class_3218)serverLevel, (class_1297)blockingEntity, (class_1282)damageSource, (class_1799)blockingEntity.method_6030());
                    float attackKnockback = (float)blockingEntity.method_45325(class_5134.field_23722);
                    attackKnockback = class_1890.method_60175((class_3218)serverLevel, (class_1799)blockingEntity.method_6030(), (class_1297)attackingEntity, (class_1282)damageSource, (float)attackKnockback);
                    attackingEntity.method_6005(0.5 * (double)attackKnockback, blockingEntity.method_23317() - attackingEntity.method_23317(), blockingEntity.method_23321() - attackingEntity.method_23321());
                    IS_BLOCKING_WITH_SHIELD.remove();
                }
            }
        }
        return EventResult.PASS;
    }

    public static EventResult onUseItemTick(class_1309 entity, class_1799 useItem, MutableInt useItemRemaining) {
        class_1792 item = useItem.method_7909();
        int itemUseDuration = useItem.method_7935(entity) - useItemRemaining.getAsInt();
        if (item instanceof class_1753 && itemUseDuration < 20 || item instanceof class_1835 && itemUseDuration < 10) {
            float chargingTime = class_1890.method_60159((class_1799)useItem, (class_1309)entity, (float)1.25f);
            useItemRemaining.mapInt(duration -> duration - class_3532.method_15375((float)((1.25f - chargingTime) / 0.25f)));
        }
        return EventResult.PASS;
    }
}

