/*
 * Decompiled with CFR 0.152.
 */
package de.mschae23.grindenchantments.impl;

import de.mschae23.grindenchantments.GrindEnchantments;
import de.mschae23.grindenchantments.GrindEnchantmentsMod;
import de.mschae23.grindenchantments.config.FilterAction;
import de.mschae23.grindenchantments.config.FilterConfig;
import de.mschae23.grindenchantments.config.ServerConfig;
import de.mschae23.grindenchantments.event.ApplyLevelCostEvent;
import de.mschae23.grindenchantments.event.GrindstoneEvents;
import java.util.function.IntSupplier;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_7225;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class DisenchantOperation
implements GrindstoneEvents.CanInsert,
GrindstoneEvents.UpdateResult,
GrindstoneEvents.CanTakeResult,
GrindstoneEvents.TakeResult,
GrindstoneEvents.LevelCost {
    @Override
    public boolean canInsert(class_1799 stack, class_1799 other, int slotId) {
        return stack.method_7909() == class_1802.field_8529 && !other.method_31574(class_1802.field_8529);
    }

    @Override
    @NotNull
    public class_1799 onUpdateResult(class_1799 input1, class_1799 input2, class_1657 player, class_7225.class_7874 wrapperLookup) {
        if (!DisenchantOperation.isDisenchantOperation(input1, input2)) {
            return class_1799.field_8037;
        }
        class_1799 enchantedItemStack = input1.method_7942() ? input1 : input2;
        ServerConfig config = GrindEnchantmentsMod.getServerConfig();
        return DisenchantOperation.transferEnchantmentsToBook(enchantedItemStack, config.filter());
    }

    @Override
    public boolean canTakeResult(class_1799 input1, class_1799 input2, class_1657 player, class_7225.class_7874 wrapperLookup) {
        if (DisenchantOperation.isDisenchantOperation(input1, input2)) {
            ServerConfig config = GrindEnchantmentsMod.getServerConfig();
            boolean stack1Book = input1.method_7909() == class_1802.field_8529;
            class_1799 enchantedItemStack = stack1Book ? input2 : input1;
            return DisenchantOperation.canTakeResult(input1, input2, () -> GrindEnchantments.getLevelCost(enchantedItemStack, config.disenchant().costFunction(), config.filter(), wrapperLookup), player);
        }
        return true;
    }

    @Override
    public boolean onTakeResult(class_1799 input1, class_1799 input2, class_1799 resultStack, class_1657 player, class_1263 input, class_7225.class_7874 wrapperLookup) {
        class_1799 bookItemStack;
        if (!DisenchantOperation.isDisenchantOperation(input1, input2)) {
            return false;
        }
        ServerConfig config = GrindEnchantmentsMod.getServerConfig();
        boolean stack1Book = input1.method_7909() == class_1802.field_8529;
        class_1799 enchantedItemStack = stack1Book ? input2 : input1;
        class_1799 class_17992 = bookItemStack = stack1Book ? input1 : input2;
        if (!player.method_31549().field_7477) {
            int cost = DisenchantOperation.debugLevelCost("onTakeResult", GrindEnchantments.getLevelCost(enchantedItemStack, config.disenchant().costFunction(), config.filter(), wrapperLookup));
            ((ApplyLevelCostEvent.ApplyLevelCost)ApplyLevelCostEvent.EVENT.invoker()).applyLevelCost(cost, player);
        }
        input.method_5447(stack1Book ? 1 : 0, config.disenchant().consumeItem() ? class_1799.field_8037 : DisenchantOperation.grind(enchantedItemStack, config.filter()));
        if (bookItemStack.method_7947() == 1) {
            input.method_5447(stack1Book ? 0 : 1, class_1799.field_8037);
        } else {
            class_1799 bookNew = bookItemStack.method_7972();
            bookNew.method_7939(bookItemStack.method_7947() - 1);
            input.method_5447(stack1Book ? 0 : 1, bookNew);
        }
        return true;
    }

    @Override
    public int getLevelCost(class_1799 input1, class_1799 input2, class_1657 player, class_7225.class_7874 wrapperLookup) {
        if (DisenchantOperation.isDisenchantOperation(input1, input2)) {
            ServerConfig config = GrindEnchantmentsMod.getServerConfig();
            boolean stack1Book = input1.method_7909() == class_1802.field_8529;
            class_1799 enchantedItemStack = stack1Book ? input2 : input1;
            return DisenchantOperation.debugLevelCost("getLevelCost", GrindEnchantments.getLevelCost(enchantedItemStack, config.disenchant().costFunction(), config.filter(), wrapperLookup));
        }
        return -1;
    }

    private static int debugLevelCost(String location, int cost) {
        return cost;
    }

    public static boolean isDisenchantOperation(class_1799 input1, class_1799 input2) {
        if (!GrindEnchantmentsMod.getServerConfig().disenchant().enabled()) {
            return false;
        }
        return input1.method_7942() && input2.method_7909() == class_1802.field_8529 || input2.method_7942() && input1.method_7909() == class_1802.field_8529;
    }

    public static boolean canTakeResult(class_1799 input1, class_1799 input2, IntSupplier cost, class_1657 player) {
        return player.method_31549().field_7477 || player.field_7520 >= cost.getAsInt();
    }

    public static class_1799 transferEnchantmentsToBook(class_1799 source, FilterConfig filter) {
        if (filter.enabled() && filter.item().action() != FilterAction.IGNORE && filter.item().action() == FilterAction.DENY == source.method_41409().method_40230().map(key -> filter.item().items().contains(key.method_29177())).orElse(false)) {
            return class_1799.field_8037;
        }
        class_9304 enchantments = GrindEnchantments.getEnchantments(source, filter);
        if (enchantments.method_57543()) {
            return class_1799.field_8037;
        }
        int repairCost = 0;
        for (int i = 0; i < enchantments.method_57541(); ++i) {
            repairCost = class_1706.method_20398((int)repairCost);
        }
        class_1799 book = new class_1799((class_1935)class_1802.field_8598);
        book.method_57379(class_9334.field_49643, (Object)enchantments);
        book.method_57379(class_9334.field_49639, (Object)repairCost);
        return book;
    }

    private static class_1799 grind(class_1799 stack, FilterConfig filter) {
        class_1799 stack2 = stack.method_7972();
        class_9304 enchantments = filter.filterReversed((class_9304)stack2.method_58695(class_1890.method_57533((class_1799)stack2), (Object)class_9304.field_49385));
        stack2.method_57379(class_1890.method_57533((class_1799)stack2), (Object)enchantments);
        if (stack2.method_31574(class_1802.field_8598) && enchantments.method_57543()) {
            stack2 = stack2.method_56701((class_1935)class_1802.field_8529, stack2.method_7947());
        }
        int repairCost = 0;
        for (int j = 0; j < enchantments.method_57541(); ++j) {
            repairCost = class_1706.method_20398((int)repairCost);
        }
        stack2.method_57379(class_9334.field_49639, (Object)repairCost);
        return stack2;
    }
}

