/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lovely_snails.client.model;

import dev.lambdaurora.lovely_snails.client.render.SnailEntityRenderState;
import net.minecraft.class_10017;
import net.minecraft.class_4587;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;

public class SnailModel
extends class_583<SnailEntityRenderState> {
    public static final String SHELL = "shell";
    public static final float ADULT_SHELL_ROTATION = -0.0436f;
    private static final float ADULT_FRONT_WIDTH = 12.0f;
    private static final float ADULT_SHELL_DIAMETER = 16.0f;
    private static final float ADULT_EYE_YAW = 0.1745f;
    private static final float ADULT_EYE_LENGTH = 12.0f;
    private static final float ADULT_EYE_DIAMETER = 2.0f;
    public static final float BABY_SHELL_ROTATION = -0.08f;
    private static final float BABY_FRONT_WIDTH = 4.0f;
    private static final float BABY_SHELL_DIAMETER = 10.0f;
    private static final float BABY_EYE_YAW = 0.1745f;
    private static final float BABY_EYE_LENGTH = 7.0f;
    private static final float BABY_EYE_DIAMETER = 1.0f;
    private final Model adultModel;
    private final Model babyModel;

    public SnailModel(class_630 root) {
        super(root);
        this.adultModel = new Model(root.method_32086("adult"), -0.0436f);
        this.babyModel = new Model(root.method_32086("baby"), -0.08f);
    }

    public static class_5607 model(class_5605 deformation) {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        SnailModel.buildAdultModel(root.method_32117("adult", new class_5606(), class_5603.field_27701), deformation);
        SnailModel.buildBabyModel(root.method_32117("baby", new class_5606(), class_5603.field_27701), deformation);
        return class_5607.method_32110((class_5609)modelData, (int)128, (int)96);
    }

    private static void buildAdultModel(class_5610 root, class_5605 deformation) {
        class_5610 body = root.method_32117("body", new class_5606().method_32101(0, 32).method_32098(-6.0f, 5.0f, -20.0f, 12.0f, 3.0f, 40.0f, deformation), class_5603.method_32090((float)0.0f, (float)16.0f, (float)-2.0f));
        class_5610 upperBody = body.method_32117("upper_body", new class_5606().method_32101(64, 16).method_32098(-6.0f, -7.0f, 0.0f, 12.0f, 12.0f, 8.0f, deformation), class_5603.method_32090((float)0.0f, (float)0.0f, (float)-20.0f));
        upperBody.method_32117("left_tentacle", new class_5606().method_32101(0, 2).method_32098(-6.0f, 0.0f, -2.0f, 4.0f, 4.0f, 2.0f, deformation), class_5603.field_27701);
        upperBody.method_32117("right_tentacle", new class_5606().method_32101(0, 2).method_32096().method_32098(2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 2.0f, deformation), class_5603.field_27701);
        root.method_32117(SHELL, new class_5606().method_32099(-6.0f, 0.0f, -2.0f, 12.0f, 16.0f, 16.0f, deformation.method_32095(4.0f, 8.0f, 8.0f), 1.0f, 1.0f), class_5603.method_32091((float)0.0f, (float)-2.0f, (float)-5.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        body.method_32117("left_eye", new class_5606().method_32101(42, 0).method_32098(-2.8336f, -15.849f, -3.8272f, 2.0f, 12.0f, 2.0f, deformation), class_5603.method_32091((float)-1.5f, (float)-4.0f, (float)-15.0f, (float)0.4363f, (float)0.1745f, (float)0.0f));
        body.method_32117("right_eye", new class_5606().method_32101(42, 0).method_32096().method_32098(0.8336f, -15.849f, -3.8272f, 2.0f, 12.0f, 2.0f, deformation), class_5603.method_32091((float)1.5f, (float)-4.0f, (float)-15.0f, (float)0.4363f, (float)-0.1745f, (float)0.0f));
    }

    private static void buildBabyModel(class_5610 babyRoot, class_5605 deformation) {
        class_5610 body = babyRoot.method_32117("body", new class_5606().method_32101(56, 0).method_32098(-2.0f, 22.0f, -7.0f, 4.0f, 2.0f, 14.0f, deformation).method_32101(0, 10).method_32098(-2.0f, 20.0f, -7.0f, 4.0f, 2.0f, 4.0f, deformation).method_32101(0, 0).method_32098(-2.0f, 22.0f, -8.0f, 1.0f, 1.0f, 1.0f, deformation).method_32098(1.0f, 22.0f, -8.0f, 1.0f, 1.0f, 1.0f, deformation), class_5603.method_32090((float)0.0f, (float)0.0f, (float)-2.0f));
        babyRoot.method_32117(SHELL, new class_5606().method_32101(0, 32).method_32098(-3.0f, 10.0f, -1.0f, 6.0f, 10.0f, 10.0f, deformation), class_5603.method_32091((float)0.0f, (float)2.2f, (float)-3.0f, (float)-0.08f, (float)0.0f, (float)0.0f));
        body.method_32117("left_eye", new class_5606().method_32101(0, 32).method_32098(-1.1664f, 19.0f, -3.8272f, 1.0f, 7.0f, 1.0f, deformation), class_5603.method_32091((float)-1.5f, (float)-4.0f, (float)-14.2f, (float)0.4363f, (float)0.1745f, (float)0.0f));
        body.method_32117("right_eye", new class_5606().method_32101(0, 32).method_32096().method_32098(0.1664f, 19.0f, -3.8272f, 1.0f, 7.0f, 1.0f, deformation), class_5603.method_32091((float)1.5f, (float)-4.0f, (float)-14.2f, (float)0.4363f, (float)-0.1745f, (float)0.0f));
    }

    public Model getCurrentModel(SnailEntityRenderState state) {
        return state.field_53457 ? this.babyModel : this.adultModel;
    }

    public void setupAnim(SnailEntityRenderState entity) {
        super.method_2819((class_10017)entity);
        Model model = this.getCurrentModel(entity);
        model.root.field_3665 = true;
        (entity.field_53457 ? this.adultModel : this.babyModel).root.field_3665 = false;
        if (entity.isScared) {
            model.hideSnail();
        } else {
            model.uncover();
        }
    }

    public static class Model {
        private final class_630 root;
        private final class_630 body;
        private final class_630 shell;
        private final float idleShellYaw;

        public Model(class_630 root, float idleShellYaw) {
            this.root = root;
            this.idleShellYaw = idleShellYaw;
            this.body = root.method_32086("body");
            this.shell = root.method_32086(SnailModel.SHELL);
        }

        public class_630 getShell() {
            return this.shell;
        }

        public void hideSnail() {
            this.body.field_3665 = false;
            this.getShell().method_33425(0.0f, 0.0f, 0.0f);
        }

        public void uncover() {
            this.body.field_3665 = true;
            this.getShell().method_33425(this.idleShellYaw, 0.0f, 0.0f);
        }

        public void updateMatrix(class_4587 matrices) {
            if (!this.body.field_3665) {
                matrices.method_46416(0.0f, 0.125f, 0.0f);
            }
        }
    }
}

