/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lovely_snails.client.screen;

import dev.lambdaurora.lovely_snails.LovelySnails;
import dev.lambdaurora.lovely_snails.entity.SnailEntity;
import dev.lambdaurora.lovely_snails.network.SnailSetStoragePagePayload;
import dev.lambdaurora.lovely_snails.screen.SnailScreenHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_8666;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class SnailInventoryScreen
extends class_465<SnailScreenHandler> {
    private static final class_2960 TEXTURE = LovelySnails.id("textures/gui/container/snail.png");
    private static final class_8666 ENDER_CHEST_SPRITES = new class_8666(LovelySnails.id("container/snail/ender_chest"), LovelySnails.id("container/snail/ender_chest_highlighted"));
    private static final class_8666[] PAGE_TAB_SPRITES = new class_8666[]{new class_8666(LovelySnails.id("container/snail/tab/1"), LovelySnails.id("container/snail/tab/1_highlighted")), new class_8666(LovelySnails.id("container/snail/tab/2"), LovelySnails.id("container/snail/tab/2_highlighted")), new class_8666(LovelySnails.id("container/snail/tab/3"), LovelySnails.id("container/snail/tab/3_highlighted"))};
    private final SnailEntity entity;
    private float mouseX;
    private float mouseY;
    private EnderChestButton enderChestButton;
    private final PageButton[] pageButtons = new PageButton[3];

    public SnailInventoryScreen(SnailScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, handler.snail().method_5476());
        this.field_2792 += 19;
        this.entity = handler.snail();
    }

    private void clearListeners() {
        if (this.enderChestButton != null) {
            ((SnailScreenHandler)this.method_17577()).getInventory().method_5488((class_1265)this.enderChestButton);
        }
        this.enderChestButton = null;
        for (int page = 0; page < 3; ++page) {
            if (this.pageButtons[page] != null) {
                ((SnailScreenHandler)this.method_17577()).getInventory().method_5488((class_1265)this.pageButtons[page]);
                ((SnailScreenHandler)this.method_17577()).removePageChangeListener(this.pageButtons[page]);
            }
            this.pageButtons[page] = null;
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.clearListeners();
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.enderChestButton = new EnderChestButton(x + 7 + 18, y + 35 + 18);
        this.method_37063((class_364)this.enderChestButton);
        ((SnailScreenHandler)this.method_17577()).getInventory().method_5489((class_1265)this.enderChestButton);
        int buttonX = x + this.field_2792 - 3;
        int buttonY = y + 17;
        for (int page = 0; page < PAGE_TAB_SPRITES.length; ++page) {
            this.pageButtons[page] = new PageButton(buttonX, buttonY, page);
            this.method_37063((class_364)this.pageButtons[page]);
            ((SnailScreenHandler)this.method_17577()).getInventory().method_5489((class_1265)this.pageButtons[page]);
            ((SnailScreenHandler)this.method_17577()).addPageChangeListener(this.pageButtons[page]);
        }
    }

    public void method_25432() {
        super.method_25432();
        this.clearListeners();
    }

    public void method_25419() {
        super.method_25419();
        this.clearListeners();
    }

    public void requestStoragePage(int page) {
        ClientPlayNetworking.send((class_8710)new SnailSetStoragePagePayload(((SnailScreenHandler)this.field_2797).field_7763, (byte)page));
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        if (mouseX > (double)(x + 98) && mouseY > (double)(y + 17) && mouseX <= (double)(x + 98 + 90) && mouseY <= (double)(y + 17 + 54)) {
            int newPage;
            int oldPage = ((SnailScreenHandler)this.method_17577()).getCurrentStoragePage();
            if (oldPage == (newPage = class_3532.method_15340((int)(oldPage + (amountY > 0.0 ? -1 : 1)), (int)0, (int)2))) {
                return true;
            }
            if (!((SnailScreenHandler)this.method_17577()).hasChest(newPage)) {
                int otherNewPage = class_3532.method_15340((int)(newPage + (amountY > 0.0 ? -1 : 1)), (int)0, (int)2);
                if (newPage == otherNewPage || !((SnailScreenHandler)this.method_17577()).hasChest(otherNewPage)) {
                    return true;
                }
                newPage = otherNewPage;
            }
            this.requestStoragePage(newPage);
            return true;
        }
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        graphics.method_25290(class_10799.field_56883, TEXTURE, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        if (this.entity.method_56991(class_1304.field_55946)) {
            graphics.method_25290(class_10799.field_56883, TEXTURE, x + 7 + 18, y + 35 - 18, 18.0f, (float)(this.field_2779 + 54), 18, 18, 256, 256);
        }
        graphics.method_25290(class_10799.field_56883, TEXTURE, x + 7 + 18, y + 35, 36.0f, (float)(this.field_2779 + 54), 18, 18, 256, 256);
        if (!this.entity.method_6109()) {
            for (int row = y + 17; row <= y + 35 + 18; row += 18) {
                graphics.method_25290(class_10799.field_56883, TEXTURE, x + 7, row, 54.0f, (float)(this.field_2779 + 54), 18, 18, 256, 256);
            }
        }
        if (((SnailScreenHandler)this.method_17577()).hasChests()) {
            graphics.method_25290(class_10799.field_56883, TEXTURE, x + 98, y + 17, 0.0f, (float)this.field_2779, 90, 54, 256, 256);
        }
        class_490.method_2486((class_332)graphics, (int)(x + 40), (int)(y + 8), (int)(x + 100), (int)(y + 70), (int)17, (float)0.35f, (float)this.mouseX, (float)this.mouseY, (class_1309)this.entity);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    private class PageButton
    extends class_344
    implements class_1265,
    SnailScreenHandler.InventoryPageChangeListener {
        private final int page;

        public PageButton(int x, int y, int page) {
            super(x, y + page * 18 + 1, 15, 16, PAGE_TAB_SPRITES[page], btn -> SnailInventoryScreen.this.requestStoragePage(page));
            this.page = page;
            this.field_22764 = ((SnailScreenHandler)SnailInventoryScreen.this.method_17577()).hasChest(this.page);
            this.onCurrentPageSet(((SnailScreenHandler)SnailInventoryScreen.this.method_17577()).getCurrentStoragePage());
        }

        public void method_5453(class_1263 sender) {
            this.field_22764 = ((SnailScreenHandler)SnailInventoryScreen.this.method_17577()).hasChest(this.page);
        }

        @Override
        public void onCurrentPageSet(int page) {
            this.field_22763 = this.page != page;
            this.method_25365(this.page == page);
        }
    }

    private class EnderChestButton
    extends class_344
    implements class_1265 {
        public EnderChestButton(int x, int y) {
            super(x, y, 18, 18, ENDER_CHEST_SPRITES, btn -> {
                class_310 client = class_310.method_1551();
                SnailScreenHandler screenHandler = (SnailScreenHandler)SnailInventoryScreen.this.method_17577();
                client.field_1761.method_2900(screenHandler.field_7763, 0);
            });
        }

        public void method_25354(class_1144 soundManager) {
            SnailEntity snail = ((SnailScreenHandler)SnailInventoryScreen.this.method_17577()).snail();
            soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14952, (float)(snail.method_59922().method_43057() * 0.1f + 0.9f), (float)0.5f));
        }

        public void method_5453(class_1263 sender) {
            this.field_22764 = this.field_22763 = ((SnailScreenHandler)SnailInventoryScreen.this.method_17577()).hasEnderChest();
        }
    }
}

