/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.microhttp;

import java.nio.ByteBuffer;
import java.util.Arrays;

class ByteTokenizer {
    private byte[] array = new byte[0];
    private int position;
    private int size;

    ByteTokenizer() {
    }

    int size() {
        return this.size;
    }

    int capacity() {
        return this.array.length;
    }

    int remaining() {
        return this.size - this.position;
    }

    void compact() {
        this.array = Arrays.copyOfRange(this.array, this.position, this.size);
        this.size -= this.position;
        this.position = 0;
    }

    void add(ByteBuffer buffer) {
        int bufferLen = buffer.remaining();
        if (this.array.length - this.size < bufferLen) {
            this.array = Arrays.copyOf(this.array, Math.max(this.size + bufferLen, this.array.length * 2));
        }
        buffer.get(this.array, this.size, bufferLen);
        this.size += bufferLen;
    }

    byte[] next(int length) {
        if (this.size - this.position < length) {
            return null;
        }
        byte[] result = Arrays.copyOfRange(this.array, this.position, this.position + length);
        this.position += length;
        return result;
    }

    byte[] next(byte[] delimiter) {
        int index = this.indexOf(delimiter);
        if (index < 0) {
            return null;
        }
        byte[] result = Arrays.copyOfRange(this.array, this.position, index);
        this.position = index + delimiter.length;
        return result;
    }

    private int indexOf(byte[] delimiter) {
        for (int i = this.position; i <= this.size - delimiter.length; ++i) {
            if (!Arrays.equals(delimiter, 0, delimiter.length, this.array, i, i + delimiter.length)) continue;
            return i;
        }
        return -1;
    }
}

