/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.microhttp;

import de.maxhenkel.audioplayer.microhttp.Options;
import java.time.Duration;

public class OptionsBuilder {
    private String host = "localhost";
    private int port = 8080;
    private boolean reuseAddr = false;
    private boolean reusePort = false;
    private Duration resolution = Duration.ofMillis(100L);
    private Duration requestTimeout = Duration.ofSeconds(60L);
    private int readBufferSize = 65536;
    private int acceptLength = 0;
    private int maxRequestSize = 0x100000;
    private int concurrency = Runtime.getRuntime().availableProcessors();

    private OptionsBuilder() {
    }

    public static OptionsBuilder newBuilder() {
        return new OptionsBuilder();
    }

    public Options build() {
        return new Options(this.host, this.port, this.reuseAddr, this.reusePort, this.resolution, this.requestTimeout, this.readBufferSize, this.acceptLength, this.maxRequestSize, this.concurrency);
    }

    public OptionsBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public OptionsBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public OptionsBuilder withReuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
        return this;
    }

    public OptionsBuilder withReusePort(boolean reusePort) {
        this.reusePort = reusePort;
        return this;
    }

    public OptionsBuilder withResolution(Duration resolution) {
        this.resolution = resolution;
        return this;
    }

    public OptionsBuilder withRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public OptionsBuilder withReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public OptionsBuilder withAcceptLength(int acceptLength) {
        this.acceptLength = acceptLength;
        return this;
    }

    public OptionsBuilder withMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public OptionsBuilder withConcurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }
}

