/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.webserver;

import de.maxhenkel.audioplayer.AudioPlayer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class TokenManager {
    private final Map<UUID, Token> tokens = new ConcurrentHashMap<UUID, Token>();

    public UUID generateToken(UUID playerId) {
        UUID token = UUID.randomUUID();
        this.tokens.put(token, new Token(token, playerId));
        return token;
    }

    @Nullable
    public UUID useToken(UUID token) {
        Token t = this.tokens.get(token);
        if (t == null) {
            return null;
        }
        this.tokens.remove(token);
        if (!t.isValid()) {
            return null;
        }
        return t.getPlayerId();
    }

    public boolean isValidToken(UUID token) {
        Token t = this.tokens.get(token);
        if (t == null) {
            return false;
        }
        return t.isValid();
    }

    public void cleanInvalidTokens() {
        this.tokens.values().removeIf(token -> !token.isValid());
    }

    protected static class Token {
        private final UUID token;
        private final UUID playerId;
        private final long time;

        public Token(UUID token, UUID playerId) {
            this.token = token;
            this.playerId = playerId;
            this.time = System.currentTimeMillis();
        }

        public UUID getToken() {
            return this.token;
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public long getTime() {
            return this.time;
        }

        public boolean isValid() {
            return System.currentTimeMillis() - this.time <= AudioPlayer.WEB_SERVER_CONFIG.tokenTimeout.get();
        }
    }
}

