/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_169;
import net.minecraft.class_181;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3542;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;

public record LootCount(List<Operation> operations) implements class_5341
{
    public static final MapCodec<LootCount> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Operation.CODEC.listOf().xmap(operationList -> operationList.stream().sorted(Comparator.comparingInt(Operation::getPrecedence)).toList(), Function.identity()).fieldOf("operations").forGetter(LootCount::operations)).apply((Applicative)builder, LootCount::new));

    public class_5342 method_29325() {
        return LootrRegistry.getLootCount();
    }

    public boolean test(class_47 lootContext) {
        class_243 incomingPos = (class_243)lootContext.method_35508(class_181.field_24424);
        if (incomingPos == null) {
            return false;
        }
        class_2338 position = new class_2338((int)incomingPos.field_1352, (int)incomingPos.field_1351, (int)incomingPos.field_1350);
        class_2586 blockEntity = lootContext.method_299().method_8321(position);
        ILootrBlockEntity ibe = LootrAPI.resolveBlockEntity(blockEntity);
        if (ibe != null && ibe.hasLootTable()) {
            Set<UUID> actualOpeners = ibe.getActualOpeners();
            if (actualOpeners == null) {
                return false;
            }
            int count = ibe.getActualOpeners().size() + 1;
            for (Operation op : this.operations) {
                if (op.test(count)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Set<class_169<?>> method_293() {
        return ImmutableSet.of((Object)class_181.field_24424);
    }

    public record Operation(Operand operand, int value) implements Predicate<Integer>
    {
        public static final Codec<Operation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Operand.CODEC.fieldOf("type").forGetter(Operation::operand), (App)PrimitiveCodec.INT.fieldOf("value").forGetter(Operation::value)).apply((Applicative)instance, Operation::new));

        public int getPrecedence() {
            return this.operand.getPrecedence();
        }

        @Override
        public boolean test(Integer integer) {
            return this.operand.test(integer, this.value);
        }
    }

    public static enum Operand implements BiPredicate<Integer, Integer>,
    class_3542
    {
        EQUALS(Integer::equals, 0),
        NOT_EQUALS((a, b) -> !a.equals(b), 0),
        LESS_THAN((a, b) -> a < b, 1),
        GREATER_THAN((a, b) -> a > b, 1),
        LESS_THAN_EQUALS((a, b) -> a <= b, 1),
        GREATER_THAN_EQUALS((a, b) -> a >= b, 1);

        public static final class_3542.class_7292<Operand> CODEC;
        private final BiPredicate<Integer, Integer> predicate;
        private final int precedence;

        private Operand(BiPredicate<Integer, Integer> predicate, int precedence) {
            this.predicate = predicate;
            this.precedence = precedence;
        }

        @Override
        public boolean test(Integer integer, Integer integer2) {
            return this.predicate.test(integer, integer2);
        }

        public int getPrecedence() {
            return this.precedence;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(Operand::values);
        }
    }
}

