/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.keyframe;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.List;
import java.util.Set;
import software.bernie.geckolib.animation.keyframe.Keyframe;
import software.bernie.geckolib.loading.math.value.Variable;

public record KeyframeStack<T extends Keyframe<?>>(List<T> xKeyframes, List<T> yKeyframes, List<T> zKeyframes) {
    public KeyframeStack() {
        this((List<T>)new ObjectArrayList(), (List<T>)new ObjectArrayList(), (List<T>)new ObjectArrayList());
    }

    public Set<Variable> getUsedVariables() {
        ReferenceOpenHashSet usedVariables = new ReferenceOpenHashSet();
        for (Keyframe keyframe : this.xKeyframes) {
            usedVariables.addAll(keyframe.getUsedVariables());
        }
        for (Keyframe keyframe : this.yKeyframes) {
            usedVariables.addAll(keyframe.getUsedVariables());
        }
        for (Keyframe keyframe : this.zKeyframes) {
            usedVariables.addAll(keyframe.getUsedVariables());
        }
        return usedVariables;
    }

    public double getLastKeyframeTime() {
        double xTime = 0.0;
        double yTime = 0.0;
        double zTime = 0.0;
        for (Keyframe frame : this.xKeyframes()) {
            xTime += frame.length();
        }
        for (Keyframe frame : this.yKeyframes()) {
            yTime += frame.length();
        }
        for (Keyframe frame : this.zKeyframes()) {
            zTime += frame.length();
        }
        return Math.max(xTime, Math.max(yTime, zTime));
    }
}

