/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

@ApiStatus.Internal
public class GeoRenderLayersContainer<T extends GeoAnimatable, O, R extends GeoRenderState> {
    private final GeoRenderer<T, O, R> renderer;
    private final List<GeoRenderLayer<T, O, R>> layers = new ObjectArrayList();
    private boolean compiledLayers = false;

    public GeoRenderLayersContainer(GeoRenderer<T, O, R> renderer) {
        this.renderer = renderer;
    }

    public List<GeoRenderLayer<T, O, R>> getRenderLayers() {
        if (!this.compiledLayers) {
            this.fireCompileRenderLayersEvent();
        }
        return this.layers;
    }

    public void addLayer(GeoRenderLayer<T, O, R> layer) {
        this.layers.add(layer);
    }

    public void fireCompileRenderLayersEvent() {
        this.compiledLayers = true;
        this.renderer.fireCompileRenderLayersEvent();
    }
}

