/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import com.mojang.blaze3d.textures.GpuTexture;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import net.minecraft.class_10186;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3673;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_897;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderer;

public final class RenderUtil {
    public static void translateMatrixToBone(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(class_4587 poseStack, GeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotation(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(bone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(class_4587 poseStack, GeoCube cube) {
        class_243 rotation = cube.rotation();
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.method_10215()));
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)rotation.method_10214(), 0.0f));
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ((float)rotation.method_10216(), 0.0f, 0.0f));
    }

    public static void scaleMatrixForBone(class_4587 poseStack, GeoBone bone) {
        poseStack.method_22905(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(pivot.method_10216() / 16.0, pivot.method_10214() / 16.0, pivot.method_10215() / 16.0);
    }

    public static void translateToPivotPoint(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(-pivot.method_10216() / 16.0, -pivot.method_10214() / 16.0, -pivot.method_10215() / 16.0);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(-bone.getPivotX() / 16.0f, -bone.getPivotY() / 16.0f, -bone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(class_4587 poseStack, GeoBone bone) {
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(class_4587 poseStack, GeoBone bone) {
        RenderUtil.translateMatrixToBone(poseStack, bone);
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
        RenderUtil.scaleMatrixForBone(poseStack, bone);
        RenderUtil.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f((Matrix4fc)inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul((Matrix4fc)baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(class_4587 poseStack, class_1297 animatable, float partialTick) {
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_5982, (float)animatable.method_36454()) - 90.0f));
        poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_6004, (float)animatable.method_36455())));
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        return matrix.add((Matrix4fc)new Matrix4f().m30(vector.x).m31(vector.y).m32(vector.z));
    }

    public static IntIntPair getTextureDimensions(class_2960 texture) {
        GpuTexture gpuTexture = class_310.method_1551().method_1531().method_4619(texture).method_68004();
        return IntIntPair.of((int)gpuTexture.getWidth(0), (int)gpuTexture.getHeight(0));
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return class_3673.method_15974() * 20.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static class_243 arrayToVec(double[] array) {
        return new class_243(array[0], array[1], array[2]);
    }

    public static void matchModelPartRot(class_630 from, GeoBone to) {
        to.updateRotation(-from.field_3654, -from.field_3675, from.field_3674);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().method_10214() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10214() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> 90.0f;
            case class_2350.field_11043 -> 270.0f;
            case class_2350.field_11034 -> 180.0f;
            default -> 0.0f;
        };
    }

    public static double lerpYaw(double delta, double start, double end) {
        double diff = (start = class_3532.method_15338((double)start)) - (end = class_3532.method_15338((double)end));
        end = diff > 180.0 || diff < -180.0 ? start + Math.copySign(360.0 - Math.abs(diff), diff) : end;
        return class_3532.method_16436((double)delta, (double)start, (double)end);
    }

    public static class_2960 getEmissiveResource(class_2960 textureLocation) {
        return textureLocation.method_45134(path -> path.replace(".png", "_glowmask.png"));
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntityType(class_1299<?> entityType) {
        GeoModel geoModel;
        Object v = class_310.method_1551().method_1561().field_4696.get(entityType);
        if (v instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)v;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoAnimatable getReplacedAnimatable(class_1299<?> entityType) {
        GeoAnimatable geoAnimatable;
        Object v = class_310.method_1551().method_1561().field_4696.get(entityType);
        if (v instanceof GeoReplacedEntityRenderer) {
            GeoReplacedEntityRenderer replacedEntityRenderer = (GeoReplacedEntityRenderer)v;
            geoAnimatable = (GeoAnimatable)replacedEntityRenderer.getAnimatable();
        } else {
            geoAnimatable = null;
        }
        return geoAnimatable;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForEntity(class_1297 entity) {
        GeoModel geoModel;
        class_897 class_8972 = class_310.method_1551().method_1561().method_3953(entity);
        if (class_8972 instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)class_8972;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForItem(class_1799 item) {
        return GeckoLibServices.Client.ITEM_RENDERING.getGeoModelForItem(item);
    }

    @Nullable
    public static GeoModel<?> getGeoModelForBlock(class_2586 blockEntity) {
        GeoModel geoModel;
        class_827 renderer = class_310.method_1551().method_31975().method_3550(blockEntity);
        if (renderer instanceof GeoRenderer) {
            GeoRenderer geoRenderer = (GeoRenderer)renderer;
            geoModel = geoRenderer.getGeoModel();
        } else {
            geoModel = null;
        }
        return geoModel;
    }

    @Nullable
    public static GeoModel<?> getGeoModelForArmor(class_1799 stack, class_1304 slot, class_10186.class_10190 type) {
        return GeckoLibServices.Client.ITEM_RENDERING.getGeoModelForArmor(stack, slot, type);
    }
}

