/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.model.parts;

import com.google.gson.annotations.SerializedName;
import eu.pb4.graves.model.parts.ModelPart;
import eu.pb4.graves.model.parts.ModelPartType;
import eu.pb4.polymer.virtualentity.api.elements.AbstractElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2675;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.joml.Vector3f;

public class ParticleModelPart
extends ModelPart<ParticleElement, ParticleModelPart> {
    @SerializedName(value="particle")
    public class_2394 particleEffect;
    @SerializedName(value="wait_duration")
    public int waitDuration = 5;
    @SerializedName(value="delta")
    public Vector3f delta = new Vector3f();
    @SerializedName(value="speed")
    public float speed = 0.0f;
    @SerializedName(value="count")
    public int count = 0;

    @Override
    public ParticleElement construct(class_3218 world) {
        return new ParticleElement(this.particleEffect, this.delta, this.speed, this.count, this.waitDuration);
    }

    @Override
    public ModelPartType type() {
        return ModelPartType.PARTICLE;
    }

    public static class ParticleElement
    extends AbstractElement {
        private final class_2394 particleEffect;
        private final Vector3f delta;
        private final float speed;
        private final int count;
        private final int waitDuration;
        private int tick = 0;
        private class_2596<class_2602> packet;

        public ParticleElement(class_2394 particleEffect, Vector3f delta, float speed, int count, int waitDuration) {
            this.particleEffect = particleEffect;
            this.delta = delta;
            this.speed = speed;
            this.count = count;
            this.waitDuration = Math.max(waitDuration, 1);
        }

        public void setOffset(class_243 offset) {
            super.setOffset(offset);
            this.packet = null;
        }

        public IntList getEntityIds() {
            return IntList.of();
        }

        public void startWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        }

        public void stopWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        }

        public void notifyMove(class_243 oldPos, class_243 currentPos, class_243 delta) {
        }

        public void tick() {
            if (this.tick++ % this.waitDuration == 0) {
                if (this.packet == null) {
                    class_243 pos = Objects.requireNonNull(this.getHolder()).getPos().method_1019(this.getOffset());
                    this.packet = new class_2675(this.particleEffect, false, false, pos.field_1352, pos.field_1351, pos.field_1350, this.delta.x, this.delta.y, this.delta.z, this.speed, this.count);
                }
                Objects.requireNonNull(this.getHolder()).sendPacket(this.packet);
            }
        }
    }
}

