/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.other;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.Grave;
import eu.pb4.graves.other.GraveUtils;
import eu.pb4.graves.other.LegacyNbtHelper;
import eu.pb4.graves.other.Location;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1306;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8824;
import net.minecraft.server.MinecraftServer;

public record VisualGraveData(GameProfile gameProfile, byte visualSkinModelLayers, class_1306 mainArm, class_2561 deathCause, long creationTime, Location location, int minecraftDay) {
    public static final VisualGraveData DEFAULT = new VisualGraveData(Grave.DEFAULT_GAME_PROFILE, -1, class_1306.field_6183, Grave.DEFAULT_DEATH_CAUSE, 0L, new Location(class_2960.method_60654((String)"the_void"), class_2338.field_10980), -1);

    public Map<String, class_2561> getPlaceholders(MinecraftServer server) {
        Config config = ConfigManager.getConfig();
        HashMap<String, class_2561> values = new HashMap<String, class_2561>();
        values.put("player", (class_2561)class_2561.method_43470((String)(this.gameProfile != null && this.gameProfile.getName() != null ? this.gameProfile.getName() : "<No player!>")));
        values.put("protection_time", (class_2561)class_2561.method_43470((String)(config.protection.protectionTime > -1 ? config.getFormattedTime(0L) : config.texts.infinityText)));
        values.put("break_time", (class_2561)class_2561.method_43470((String)(config.protection.breakingTime > -1 ? config.getFormattedTime(0L) : config.texts.infinityText)));
        values.put("xp", (class_2561)class_2561.method_43470((String)"0"));
        values.put("item_count", (class_2561)class_2561.method_43470((String)"0"));
        values.put("position", (class_2561)class_2561.method_43470((String)this.location.blockPos().method_23854()));
        values.put("world", GraveUtils.toWorldName(this.location.world()));
        values.put("death_cause", this.deathCause);
        values.put("minecraft_day", (class_2561)class_2561.method_43470((String)("" + this.minecraftDay)));
        values.put("creation_date", (class_2561)class_2561.method_43470((String)config.texts.fullDateFormat.format().format(new Date(this.creationTime * 1000L))));
        values.put("since_creation", (class_2561)class_2561.method_43470((String)config.getFormattedTime(System.currentTimeMillis() / 1000L - this.creationTime)));
        values.put("id", (class_2561)class_2561.method_43470((String)"<no id>"));
        return values;
    }

    public void writeData(class_11372 view) {
        view.method_71468("GameProfile", class_2487.field_25128, (Object)LegacyNbtHelper.writeGameProfile(new class_2487(), this.gameProfile));
        view.method_71468("DeathCause", class_8824.field_46597, (Object)this.deathCause);
        view.method_71466("CreationTime", this.creationTime);
        view.method_71465("MinecraftDay", this.minecraftDay);
        view.method_71462("SkinModelParts", this.visualSkinModelLayers);
        view.method_71462("MainArm", (byte)this.mainArm.method_7362());
        this.location.writeData(view);
    }

    public static VisualGraveData readData(class_11368 view) {
        return new VisualGraveData(LegacyNbtHelper.toGameProfile(view.method_71426("GameProfile", class_2487.field_25128).orElse(new class_2487())), view.method_71421("SkinModelParts", (byte)-1), view.method_71421("MainArm", (byte)0) == class_1306.field_6182.method_7362() ? class_1306.field_6182 : class_1306.field_6183, (class_2561)view.method_71426("DeathCause", class_8824.field_46597).orElse(class_2561.method_43473()), view.method_71425("CreationTime", 0L), Location.readData(view), view.method_71424("MinecraftDay", 0));
    }
}

