/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.client.gui;

import dev.architectury.hooks.fluid.FluidStackHooks;
import me.itzme1on.alcocraftplus.client.gui.handler.KegGuiHandler;
import me.itzme1on.alcocraftplus.core.utils.ColorUtil;
import me.itzme1on.alcocraftplus.core.utils.IdentifierUtil;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_465;

public class KegGui
extends class_465<KegGuiHandler> {
    private static final class_2960 TEXTURE = IdentifierUtil.of("textures/gui/keg_gui.png");
    private static final class_2960 BG = IdentifierUtil.of("textures/gui/dark_bg.png");
    private static final class_3611 DEFAULT_FLUID = class_3612.field_15910;
    private static final int[] BUBBLE_LENGTHS = new int[]{0, 6, 11, 16, 20, 24, 28};
    private static final int BG_WIDTH = 170;
    private static final int BG_HEIGHT = 162;
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int BACKGROUND_INSET = 3;
    private static final int FLUID_X_OFFSET = 3;
    private static final int FLUID_Y_OFFSET = 3;
    private static final int BUBBLE_X_OFFSET = 150;
    private static final int BUBBLE_Y_OFFSET = 17;
    private static final int BUBBLE_AREA_HEIGHT = 28;
    private static final int BUBBLE_ANIM_DURATION_TICKS = 20;
    private int bubbleAnimationTimer;

    public KegGui(KegGuiHandler menu, class_1661 inventory, class_2561 title) {
        super((class_1703)menu, inventory, title);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2 - 2;
        int fluidX = (this.field_22789 - this.field_2792) / 2 + 3;
        int fluidY = (this.field_22790 - this.field_2779) / 2 + 3;
        guiGraphics.method_25290(class_10799.field_56883, BG, x + 3, y + 3, 0.0f, 0.0f, this.field_2792 - 6, this.field_2779 - 6, 170, 162);
        this.renderFluid(guiGraphics, fluidX, fluidY);
        guiGraphics.method_25290(class_10799.field_56883, TEXTURE, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779 + 2, 256, 256);
        this.renderProgressBars(guiGraphics, x, y);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics, mouseX, mouseY, delta);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_37432() {
        super.method_37432();
        this.bubbleAnimationTimer = ((KegGuiHandler)this.field_2797).isCrafting() ? (this.bubbleAnimationTimer + 1) % 20 : 0;
    }

    private void renderProgressBars(class_332 guiGraphics, int x, int y) {
        if (((KegGuiHandler)this.field_2797).isCrafting()) {
            int bubbleIndex = this.bubbleAnimationTimer * BUBBLE_LENGTHS.length / 20;
            if (bubbleIndex >= BUBBLE_LENGTHS.length) {
                bubbleIndex = 0;
            }
            int bubbleHeight = this.getBubbleHeight(bubbleIndex);
            guiGraphics.method_25290(class_10799.field_56883, TEXTURE, x + 150, y + 17 + 28 - bubbleHeight, 176.0f, (float)(28 - bubbleHeight), 11, bubbleHeight, 256, 256);
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_27535(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0xFF000000 | ColorUtil.getColorFromRGB(215, 171, 121));
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0xFF000000 | ColorUtil.getColorFromRGB(64, 64, 64), false);
        this.renderTimer(guiGraphics);
    }

    private void renderTimer(class_332 guiGraphics) {
        int colorShadow = 0xFF000000 | ColorUtil.getColorFromRGB(97, 69, 36);
        int colorText = 0xFF000000 | ColorUtil.getColorFromRGB(215, 171, 121);
        int progress = ((KegGuiHandler)this.field_2797).getProgress();
        int maxProgress = ((KegGuiHandler)this.field_2797).getMaxProgress();
        if (!((KegGuiHandler)this.field_2797).isCrafting()) {
            guiGraphics.method_25303(this.field_22793, "00:00", 143, 47, colorShadow);
            guiGraphics.method_25303(this.field_22793, "00:00", 143, 47, colorText);
        } else if (maxProgress > 0) {
            int remainingProgress = maxProgress - progress;
            int timeInSeconds = remainingProgress / 20;
            String formattedTime = this.formatTime(timeInSeconds);
            guiGraphics.method_25303(this.field_22793, formattedTime, 143, 47, colorShadow);
            guiGraphics.method_25303(this.field_22793, formattedTime, 143, 47, colorText);
        } else {
            guiGraphics.method_25303(this.field_22793, "00:00", 143, 47, colorShadow);
            guiGraphics.method_25303(this.field_22793, "00:00", 143, 47, colorText);
        }
    }

    private void renderFluid(class_332 guiGraphics, int x, int y) {
        int color;
        int beerLevel = ((KegGuiHandler)this.field_2797).getBeerLevel();
        int beerType = ((KegGuiHandler)this.field_2797).getBeerType();
        int waterLevel = ((KegGuiHandler)this.field_2797).getWaterLevel();
        int maxWaterLevel = 32;
        class_1058 sprite = FluidStackHooks.getStillTexture((class_3611)DEFAULT_FLUID);
        if (beerLevel > 0) {
            color = this.getBeerColor(beerType);
            assert (sprite != null);
            this.renderFluidArea(guiGraphics, x, y, beerLevel, maxWaterLevel, color, sprite);
        }
        if (waterLevel > 0 && beerLevel < maxWaterLevel) {
            color = this.getGuiFluidColor();
            assert (sprite != null);
            this.renderFluidArea(guiGraphics, x, y, waterLevel, maxWaterLevel, color, sprite);
        }
    }

    private int getGuiFluidColor() {
        if (DEFAULT_FLUID == class_3612.field_15910 || DEFAULT_FLUID == class_3612.field_15909) {
            return ColorUtil.getColorFromRGB(63, 118, 228);
        }
        int c = FluidStackHooks.getColor((class_3611)DEFAULT_FLUID);
        int rgb = c & 0xFFFFFF;
        if (rgb == 0) {
            return ColorUtil.getColorFromRGB(255, 255, 255);
        }
        return rgb;
    }

    private void renderFluidArea(class_332 guiGraphics, int x, int y, int fluidLevel, int maxFluidLevel, int color, class_1058 sprite) {
        int textureWidth = 16;
        int textureHeight = 16;
        int argb = 0xFF000000 | color & 0xFFFFFF;
        int denom = Math.max(1, maxFluidLevel / 4);
        int rows = Math.min(4, (int)Math.ceil((double)fluidLevel / (double)denom));
        int srcW = sprite.method_45851().method_45807();
        int srcH = sprite.method_45851().method_45815();
        float u0 = sprite.method_4594();
        float u1 = sprite.method_4577();
        float v0 = sprite.method_4593();
        float v1 = sprite.method_4575();
        int atlasW = Math.max(1, Math.round((float)srcW / (u1 - u0)));
        int atlasH = Math.max(1, Math.round((float)srcH / (v1 - v0)));
        float uPx = u0 * (float)atlasW;
        float vPx = v0 * (float)atlasH;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col <= 8; ++col) {
                guiGraphics.method_25291(class_10799.field_56883, sprite.method_45852(), x + 16 * col, y + 16 * (3 - row), uPx, vPx, 16, 16, atlasW, atlasH, argb);
            }
        }
    }

    private int getBeerColor(int beerType) {
        return switch (beerType) {
            case 1 -> ColorUtil.getColorFromRGB(222, 167, 81);
            case 2 -> ColorUtil.getColorFromRGB(201, 125, 31);
            case 3 -> ColorUtil.getColorFromRGB(107, 30, 5);
            case 4 -> ColorUtil.getColorFromRGB(29, 5, 3);
            case 5 -> ColorUtil.getColorFromRGB(170, 14, 1);
            case 6 -> ColorUtil.getColorFromRGB(75, 165, 128);
            case 7 -> ColorUtil.getColorFromRGB(58, 70, 123);
            case 8 -> ColorUtil.getColorFromRGB(143, 181, 246);
            case 9 -> ColorUtil.getColorFromRGB(188, 137, 39);
            case 10 -> ColorUtil.getColorFromRGB(69, 201, 72);
            case 11 -> ColorUtil.getColorFromRGB(142, 102, 141);
            case 12 -> ColorUtil.getColorFromRGB(236, 231, 255);
            default -> ColorUtil.getColorFromRGB(255, 255, 255);
        };
    }

    private String formatTime(int time) {
        int minutes = time / 60;
        int seconds = time % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    private int getBubbleHeight(int bubbleIndex) {
        return BUBBLE_LENGTHS[bubbleIndex % BUBBLE_LENGTHS.length];
    }
}

