/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.blocks.keg;

import java.util.Optional;
import me.itzme1on.alcocraftplus.client.gui.handler.KegGuiHandler;
import me.itzme1on.alcocraftplus.core.helpers.ImplementedInventory;
import me.itzme1on.alcocraftplus.core.recipes.KegRecipeInput;
import me.itzme1on.alcocraftplus.core.recipes.KegRecipes;
import me.itzme1on.alcocraftplus.core.registries.BlockEntitiesRegistry;
import me.itzme1on.alcocraftplus.core.registries.RecipesRegistry;
import me.itzme1on.alcocraftplus.core.utils.BeerTypeMapperUtil;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KegEntity
extends class_2586
implements class_3908,
ImplementedInventory,
class_5558<KegEntity> {
    public static final int MAX_BUCKETS = 4;
    public static final int MAX_MUGS = 8;
    public static final int MAX_WATER_LEVEL = 32;
    public static final int WATER_PER_BUCKET = 8;
    public static final int BEER_PER_MUG = 4;
    private static final int MAX_PROGRESS = 18000;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    public int waterLevel = 0;
    public int beerLevel = 0;
    public int beerType = 0;
    private int progress = 0;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> KegEntity.this.progress;
                case 1 -> 18000;
                case 2 -> KegEntity.this.waterLevel;
                case 3 -> KegEntity.this.beerLevel;
                case 4 -> KegEntity.this.beerType;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    KegEntity.this.progress = value;
                    break;
                }
                case 2: {
                    KegEntity.this.waterLevel = value;
                    break;
                }
                case 3: {
                    KegEntity.this.beerLevel = value;
                    break;
                }
                case 4: {
                    KegEntity.this.beerType = value;
                }
            }
        }

        public int method_17389() {
            return 5;
        }
    };

    public KegEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntitiesRegistry.KEG_ENTITY.get(), pos, state);
    }

    private static Optional<class_8786<KegRecipes>> findMatchingRecipe(KegEntity entity) {
        if (entity.field_11863 == null || entity.field_11863.method_8503() == null) {
            return Optional.empty();
        }
        KegRecipeInput input = new KegRecipeInput(entity.inventory);
        return entity.field_11863.method_8503().method_3772().method_8132((class_3956)RecipesRegistry.KEG_RECIPE_TYPE.get(), (class_9695)input, entity.field_11863);
    }

    private static Optional<class_8786<KegRecipes>> canBrewRecipe(KegEntity entity) {
        Optional<class_8786<KegRecipes>> match = KegEntity.findMatchingRecipe(entity);
        if (match.isPresent() && !KegEntity.hasBeer(entity) && KegEntity.hasWater(entity)) {
            return match;
        }
        return Optional.empty();
    }

    private static boolean hasWater(KegEntity entity) {
        return entity.waterLevel > 0;
    }

    private static boolean hasBeer(KegEntity entity) {
        return entity.beerLevel > 0;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.alcocraftplus.keg");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new KegGuiHandler(id, inventory, (class_1263)this, this.propertyDelegate);
    }

    protected void method_11014(class_11368 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_11368)nbt, this.inventory);
        this.progress = nbt.method_71424("progress", 0);
        this.waterLevel = nbt.method_71424("waterLevel", 0);
        this.beerLevel = nbt.method_71424("beerLevel", 0);
        this.beerType = nbt.method_71424("beerType", 0);
    }

    protected void method_11007(class_11372 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_11372)nbt, this.inventory);
        nbt.method_71465("progress", this.progress);
        nbt.method_71465("waterLevel", this.waterLevel);
        nbt.method_71465("beerLevel", this.beerLevel);
        nbt.method_71465("beerType", this.beerType);
    }

    public boolean method_5437(int index, class_1799 stack) {
        return index >= 0 && index < this.inventory.size();
    }

    public void tick(class_1937 level, class_2338 pos, class_2680 state, KegEntity entity) {
        if (!level.method_8608()) {
            class_5819 random = level.field_9229;
            Optional<class_8786<KegRecipes>> match = KegEntity.canBrewRecipe(entity);
            if (match.isPresent()) {
                ++entity.progress;
                if (random.method_43057() < 0.005f) {
                    level.method_8396(null, pos, class_3417.field_15021, class_3419.field_15245, 0.1f, 0.5f);
                }
                if (entity.progress >= 18000) {
                    this.brew(level, pos, state, entity, match.get());
                }
            } else {
                entity.resetProgress();
            }
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return this.field_11863 != null && this.field_11863.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    private void brew(class_1937 level, class_2338 pos, class_2680 state, KegEntity entity, class_8786<KegRecipes> holder) {
        for (int i = 0; i < entity.inventory.size(); ++i) {
            if (((class_1799)entity.inventory.get(i)).method_7960()) continue;
            ((class_1799)entity.inventory.get(i)).method_7934(1);
        }
        entity.beerType = BeerTypeMapperUtil.getBeerType(((KegRecipes)holder.comp_1933()).getResultItem().method_7909());
        int fullMugs = entity.waterLevel / 4;
        entity.beerLevel = fullMugs * 4;
        entity.waterLevel = 0;
        entity.resetProgress();
        KegEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
    }

    private void resetProgress() {
        this.progress = 0;
    }
}

