/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.effects;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.itzme1on.alcocraftplus.core.mixin.AttractTracked;
import me.itzme1on.alcocraftplus.core.registries.EffectsRegistry;
import me.itzme1on.alcocraftplus.core.utils.ColorUtil;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class AttractEffect
extends class_1291 {
    private static final long PARTICLE_INTERVAL_TICKS = 20L;
    private static final double PARTICLES_PER_BLOCK = 2.0;
    private static final class_2390 DUST_COLOR = new class_2390(ColorUtil.getColorFromRGB(170, 14, 1), 0.5f);
    private static final double SEARCH_RADIUS_BLOCKS = 15.0;
    private static final double ATTRACT_RING_RADIUS_BLOCKS = 1.0;
    private static final double EPSILON = 1.0E-4;
    private static final double MAX_VERTICAL_DELTA = 0.35;
    private static class_6880<class_1291> ATTRACT_HOLDER;

    public AttractEffect(class_4081 category, int color) {
        super(category, color);
    }

    private static class_6880<class_1291> attractHolder() {
        if (ATTRACT_HOLDER == null) {
            ATTRACT_HOLDER = class_7923.field_41174.method_47983((Object)((class_1291)EffectsRegistry.ATTRACT.get()));
        }
        return ATTRACT_HOLDER;
    }

    private static Set<class_1542> selectParticleSources(List<class_1542> nearbyItems, List<class_1309> attractEffectHolders, class_1309 contextHolder) {
        HashMap<class_2338, class_1542> bestItemByBlock = new HashMap<class_2338, class_1542>();
        HashMap<class_2338, Double> bestDist2ByBlock = new HashMap<class_2338, Double>();
        if (attractEffectHolders.isEmpty()) {
            return Collections.emptySet();
        }
        for (class_1542 item : nearbyItems) {
            class_1309 nearest;
            if (!item.method_5805() || item.field_6012 < 20 || (nearest = AttractEffect.findNearest(attractEffectHolders, item)) == null || nearest.method_5628() != contextHolder.method_5628()) continue;
            double distanceToItem = AttractEffect.squaredDistanceFeetToItem(nearest, item);
            class_2338 key = item.method_24515();
            Double best = (Double)bestDist2ByBlock.get(key);
            if (best != null && !(distanceToItem < best)) continue;
            bestDist2ByBlock.put(key, distanceToItem);
            bestItemByBlock.put(key, item);
        }
        return new HashSet<class_1542>(bestItemByBlock.values());
    }

    private static class_1309 findNearest(List<class_1309> holders, class_1542 item) {
        class_1309 nearest = null;
        double bestDist2 = Double.MAX_VALUE;
        for (class_1309 h : holders) {
            double d2 = AttractEffect.squaredDistanceFeetToItem(h, item);
            if (!(d2 < bestDist2)) continue;
            bestDist2 = d2;
            nearest = h;
        }
        return nearest;
    }

    private static class_243 itemCenter(class_1542 item) {
        return new class_243(item.method_23317(), item.method_23318() + (double)item.method_17682() * 0.5, item.method_23321());
    }

    private static class_243 entityFeet(class_1309 e) {
        return new class_243(e.method_23317(), e.method_23318() + 0.05, e.method_23321());
    }

    private static class_243 entityWaist(class_1309 e) {
        return new class_243(e.method_23317(), e.method_23318() + (double)e.method_17682() * 0.5, e.method_23321());
    }

    private static double squaredDistanceFeetToItem(class_1309 e, class_1542 item) {
        class_243 feet = AttractEffect.entityFeet(e);
        class_243 center = AttractEffect.itemCenter(item);
        double dx = feet.field_1352 - center.field_1352;
        double dy = feet.field_1351 - center.field_1351;
        double dz = feet.field_1350 - center.field_1350;
        return dx * dx + dy * dy + dz * dz;
    }

    private static class_243 sphericalTargetAroundFeet(class_1542 item, class_1309 target) {
        class_243 from = AttractEffect.itemCenter(item);
        class_243 to = AttractEffect.entityFeet(target);
        return AttractEffect.computeRingPointTowardTarget(from, to);
    }

    private static class_243 sphericalTargetAroundWaist(class_1542 item, class_1309 target) {
        class_243 from = AttractEffect.itemCenter(item);
        class_243 to = AttractEffect.entityWaist(target);
        return AttractEffect.computeRingPointTowardTarget(from, to);
    }

    @NotNull
    private static class_243 computeRingPointTowardTarget(class_243 from, class_243 to) {
        class_243 diff = to.method_1020(from);
        double len = Math.max(diff.method_1033(), 1.0E-4);
        class_243 unit = diff.method_1021(1.0 / len);
        return new class_243(to.field_1352 - unit.field_1352 * 1.0, to.field_1351 - unit.field_1351 * 1.0, to.field_1350 - unit.field_1350 * 1.0);
    }

    private static void spawnDustLine(class_3218 level, class_243 from, class_243 to) {
        double distance = from.method_1022(to);
        int points = class_3532.method_15340((int)((int)Math.floor(distance * 2.0) + 1), (int)1, (int)200);
        if (points <= 1 || distance < 1.0E-6) {
            return;
        }
        double stepX = (to.field_1352 - from.field_1352) / (double)(points - 1);
        double stepY = (to.field_1351 - from.field_1351) / (double)(points - 1);
        double stepZ = (to.field_1350 - from.field_1350) / (double)(points - 1);
        double x = from.field_1352;
        double y = from.field_1351;
        double z = from.field_1350;
        for (int i = 0; i < points; ++i) {
            level.method_65096((class_2394)DUST_COLOR, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            x += stepX;
            y += stepY;
            z += stepZ;
        }
    }

    public boolean method_5572(class_3218 level, class_1309 entity, int i) {
        if (level.field_9236) {
            return true;
        }
        class_238 searchBox = entity.method_5829().method_1014(15.0);
        List nearbyItems = level.method_18467(class_1542.class, searchBox);
        List<class_1309> attractEffectHolders = level.method_18467(class_1309.class, searchBox).stream().filter(e -> e.method_5805() && e.method_6059(AttractEffect.attractHolder())).toList();
        if (attractEffectHolders.isEmpty() || nearbyItems.isEmpty()) {
            return true;
        }
        Set<class_1542> particleSources = AttractEffect.selectParticleSources(nearbyItems, attractEffectHolders, entity);
        HashMap<Integer, Integer> amplifierByHolderId = new HashMap<Integer, Integer>();
        for (class_1309 holder : attractEffectHolders) {
            class_1293 inst = holder.method_6112(AttractEffect.attractHolder());
            amplifierByHolderId.put(holder.method_5628(), inst == null ? 0 : inst.method_5578());
        }
        for (class_1542 item : nearbyItems) {
            class_243 velocity;
            if (!item.method_5805() || item.field_6012 < 20) continue;
            class_1309 nearestHolder = AttractEffect.findNearest(attractEffectHolders, item);
            if (item instanceof AttractTracked) {
                AttractTracked trackedId = (AttractTracked)item;
                trackedId.alcocraftplus$setAttractorId(nearestHolder != null ? nearestHolder.method_5628() : 0);
            }
            if (nearestHolder == null || entity.method_5628() != nearestHolder.method_5628()) continue;
            class_243 itemCenter = AttractEffect.itemCenter(item);
            class_243 holderFeet = AttractEffect.entityFeet(nearestHolder);
            class_243 toFeet = holderFeet.method_1020(itemCenter);
            double distanceToFeet = Math.max(toFeet.method_1033(), 1.0E-4);
            class_243 updatedVelocity = velocity = item.method_18798();
            if (distanceToFeet <= 1.0) {
                if (!(level instanceof class_3218)) continue;
                class_3218 serverLevel = level;
                if (!particleSources.contains(item) || serverLevel.method_8510() % 20L != 0L) continue;
                class_243 waistTarget = AttractEffect.sphericalTargetAroundWaist(item, nearestHolder);
                AttractEffect.spawnDustLine(serverLevel, itemCenter, waistTarget);
                continue;
            }
            class_243 weightedDirectionSum = class_243.field_1353;
            double totalWeight = 0.0;
            for (class_1309 holder : attractEffectHolders) {
                double feetDistance;
                class_243 targetPoint = AttractEffect.sphericalTargetAroundFeet(item, holder);
                class_243 toTarget = targetPoint.method_1020(itemCenter);
                double toTargetLength = toTarget.method_1033();
                if (toTargetLength <= 1.0E-6 || (feetDistance = Math.sqrt(AttractEffect.squaredDistanceFeetToItem(holder, item))) > 15.0) continue;
                double closenessNorm = (15.0 - Math.min(feetDistance, 15.0)) / 15.0;
                double weight = closenessNorm * closenessNorm;
                totalWeight += weight;
                weightedDirectionSum = weightedDirectionSum.method_1019(toTarget.method_1021(1.0 / toTargetLength * weight));
            }
            if (weightedDirectionSum.method_1027() > 1.0E-6) {
                class_243 direction = weightedDirectionSum.method_1029();
                double weightFactor = Math.min(totalWeight, 1.0);
                int nearestAmplifier = amplifierByHolderId.getOrDefault(nearestHolder.method_5628(), 0);
                double acceleration = 0.08 + 0.02 * (double)Math.max(0, nearestAmplifier);
                class_243 deltaV = direction.method_1021(weightFactor * acceleration);
                if (deltaV.field_1351 > 0.35) {
                    deltaV = new class_243(deltaV.field_1352, 0.35, deltaV.field_1350);
                }
                if (deltaV.field_1351 < -0.35) {
                    deltaV = new class_243(deltaV.field_1352, -0.35, deltaV.field_1350);
                }
                updatedVelocity = velocity.method_1019(deltaV);
            }
            if (updatedVelocity.field_1351 > 0.35) {
                updatedVelocity = new class_243(updatedVelocity.field_1352, 0.35, updatedVelocity.field_1350);
            }
            if (updatedVelocity.field_1351 < -0.35) {
                updatedVelocity = new class_243(updatedVelocity.field_1352, -0.35, updatedVelocity.field_1350);
            }
            item.method_18799(updatedVelocity);
            if (item instanceof AttractTracked) {
                AttractTracked tracked = (AttractTracked)item;
                class_243 appliedAcceleration = updatedVelocity.method_1020(velocity);
                tracked.alcocraftplus$setAttractAccel(appliedAcceleration);
                tracked.alcocraftplus$setAttractTtl(2);
            }
            if (!(level instanceof class_3218)) continue;
            class_3218 serverLevel = level;
            if (!particleSources.contains(item) || serverLevel.method_8510() % 20L != 0L) continue;
            class_243 toWaist = AttractEffect.sphericalTargetAroundWaist(item, nearestHolder);
            AttractEffect.spawnDustLine(serverLevel, itemCenter, toWaist);
        }
        return true;
    }

    public boolean method_5552(int duration, int amplifier) {
        return true;
    }
}

