/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10124;
import net.minecraft.class_10132;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_4081;
import net.minecraft.class_5250;
import net.minecraft.class_9298;
import net.minecraft.class_9334;

public final class TooltipUtil {
    private TooltipUtil() {
    }

    public static void appendItemEffectTooltips(class_1799 itemStack, Consumer<class_2561> addLine) {
        class_10124 consumable;
        class_9298 stewEffects;
        record EffectRow(class_1293 instance, float probability, boolean showChance) {
        }
        ArrayList<EffectRow> collectedEffects = new ArrayList<EffectRow>();
        class_1844 potionContents = (class_1844)itemStack.method_58694(class_9334.field_49651);
        if (potionContents != null) {
            for (class_1293 mobEffectInstance : potionContents.method_57397()) {
                collectedEffects.add(new EffectRow(mobEffectInstance, 1.0f, false));
            }
        }
        if ((stewEffects = (class_9298)itemStack.method_58694(class_9334.field_49652)) != null) {
            stewEffects.comp_2416().forEach(stewEntry -> {
                class_1293 mobEffectInstance = new class_1293(stewEntry.comp_1838(), stewEntry.comp_1839(), 0);
                collectedEffects.add(new EffectRow(mobEffectInstance, 1.0f, false));
            });
        }
        if ((consumable = (class_10124)itemStack.method_58694(class_9334.field_53964)) != null) {
            consumable.comp_3089().forEach(effect -> {
                if (effect instanceof class_10132) {
                    float probability;
                    List patt1$temp;
                    class_10132 $b$0 = (class_10132)effect;
                    List effects = patt1$temp = $b$0.comp_3094();
                    try {
                        float patt2$temp;
                        probability = patt2$temp = $b$0.comp_3095();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    for (class_1293 eff : effects) {
                        collectedEffects.add(new EffectRow(eff, probability, probability < 0.9999f));
                    }
                }
            });
        }
        if (collectedEffects.isEmpty()) {
            return;
        }
        collectedEffects.sort(Comparator.comparingInt(r -> ((class_1291)r.instance.method_5579().comp_349()).method_18792() == class_4081.field_18272 ? 1 : 0).thenComparingInt(r -> -r.instance.method_5578()).thenComparing(r -> ((class_1291)r.instance.method_5579().comp_349()).method_5560().getString()));
        for (EffectRow row : collectedEffects) {
            addLine.accept(TooltipUtil.formatEffectLine(row.instance, row.probability, row.showChance));
        }
        addLine.accept((class_2561)class_2561.method_43473());
    }

    public static void appendItemEffectTooltips(class_1799 itemStack, List<class_2561> tooltipLines) {
        TooltipUtil.appendItemEffectTooltips(itemStack, tooltipLines::add);
    }

    public static class_2561 styledKeyFromMapping(class_304 keyMapping, boolean isActive) {
        return keyMapping.method_16007().method_27661().method_27692(isActive ? class_124.field_1068 : class_124.field_1080);
    }

    private static class_2561 formatEffectLine(class_1293 mobEffectInstance, float probability, boolean showChance) {
        class_1291 mobEffect = (class_1291)mobEffectInstance.method_5579().comp_349();
        class_2561 effectDisplayName = mobEffect.method_5560();
        int amplifier = mobEffectInstance.method_5578();
        int totalTicks = mobEffectInstance.method_5584();
        class_5250 line = class_2561.method_43470((String)"").method_10852(effectDisplayName);
        if (amplifier > 0) {
            line.method_10852((class_2561)class_2561.method_43470((String)(" " + TooltipUtil.toRomanNumeral(amplifier + 1))));
        }
        if (totalTicks > 0) {
            line.method_10852((class_2561)class_2561.method_43470((String)(" (" + TooltipUtil.formatDurationTicksToMMSS(totalTicks) + ")")));
        }
        if (showChance) {
            int pct = Math.round(probability * 100.0f);
            line.method_10852((class_2561)class_2561.method_43470((String)(" (" + pct + "%)")));
        }
        class_124 color = switch (mobEffect.method_18792()) {
            case class_4081.field_18271 -> class_124.field_1078;
            case class_4081.field_18272 -> class_124.field_1061;
            default -> class_124.field_1080;
        };
        return line.method_27692(color);
    }

    private static String formatDurationTicksToMMSS(int durationTicks) {
        int totalSeconds = Math.max(0, durationTicks / 20);
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    private static String toRomanNumeral(int value) {
        int[] arabic = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] roman = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        int remaining = Math.max(1, Math.min(3999, value));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arabic.length; ++i) {
            while (remaining >= arabic[i]) {
                remaining -= arabic[i];
                sb.append(roman[i]);
            }
        }
        return sb.toString();
    }
}

