/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.model.loading.v1.CustomUnbakedBlockStateModel;
import net.fabricmc.fabric.api.client.model.loading.v1.UnbakedModelDeserializer;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_10419;
import net.minecraft.class_1047;
import net.minecraft.class_10526;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10801;
import net.minecraft.class_10813;
import net.minecraft.class_10817;
import net.minecraft.class_10819;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1100;
import net.minecraft.class_11515;
import net.minecraft.class_1767;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_809;
import net.minecraft.class_813;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BackpackDynamicModel
implements class_1100,
class_10526 {
    private final Map<ModelParts, class_793> modelParts;
    private final class_11515 renderType;

    private BackpackDynamicModel(Map<ModelParts, class_793> modelParts, class_11515 renderType) {
        this.modelParts = modelParts;
        this.renderType = renderType;
    }

    public DynamicBlockStateModel bakeBlockStateModel(class_7775 baker, class_10819 resolvedModel, class_3665 modelState) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.modelParts.forEach((part, model) -> builder.put((Object)part, (Object)baker.method_45872(model.comp_3744()).method_68044().bake(this.getTextureSlots(baker, (class_1100)model, (class_10813)resolvedModel), baker, modelState, (class_10813)resolvedModel)));
        return new DynamicBlockStateModel((Map<ModelParts, class_10817>)builder.build(), modelState, resolvedModel.method_68033(this.getTextureSlots(baker, (class_1100)this.modelParts.get((Object)ModelParts.BASE), (class_10813)resolvedModel), baker), this.renderType);
    }

    private class_10419 getTextureSlots(class_7775 baker, class_1100 partModel, class_10813 debugName) {
        class_10419.class_10423 resolver = new class_10419.class_10423();
        resolver.method_65550(partModel.comp_3743());
        class_2960 parent = partModel.comp_3744();
        if (parent != null) {
            for (class_10819 resolvedParent = baker.method_45872(parent); resolvedParent != null; resolvedParent = resolvedParent.method_68038()) {
                resolver.method_65550(resolvedParent.method_68031().comp_3743());
            }
        }
        return resolver.method_65551(debugName);
    }

    public void method_62326(class_10526.class_10103 resolver) {
        this.modelParts.values().forEach(model -> {
            class_2960 parent = model.comp_3744();
            if (parent != null) {
                resolver.markDependency(parent);
            }
        });
    }

    public static final class DynamicBlockStateModel
    implements class_1087 {
        private final Map<ModelParts, class_10817> models;
        private final class_3665 modelTransform;
        private final class_1058 particleIcon;
        private final class_11515 renderType;
        public boolean isDyed;
        public boolean isSleepingBagDeployed;
        public int sleepingBagColor;
        public RenderInfo renderInfo;
        public class_2248 block;

        public DynamicBlockStateModel(Map<ModelParts, class_10817> models, class_3665 modelTransform, class_1058 particleIcon, class_11515 renderType) {
            this.models = models;
            this.modelTransform = modelTransform;
            this.particleIcon = particleIcon;
            this.renderType = renderType;
        }

        public Object createGeometryKey(class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random) {
            return null;
        }

        public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
            BackpackBlockEntity.BackpackRenderData renderData = (BackpackBlockEntity.BackpackRenderData)blockView.getBlockEntityRenderData(pos);
            if (renderData == null) {
                renderData = new BackpackBlockEntity.BackpackRenderData(RenderInfo.EMPTY, -1, false, class_1767.field_7964.method_7789());
            }
            this.block = state.method_26204();
            this.isDyed = renderData.dyeColor() != -1;
            this.renderInfo = renderData.info() == null ? RenderInfo.EMPTY : renderData.info();
            this.sleepingBagColor = renderData.sleepingBagColor();
            this.isSleepingBagDeployed = renderData.isSleepingBagDeployed();
            this.getQuads().forEach(quad -> emitter.fromBakedQuad(quad).renderLayer(this.renderType).emit());
        }

        private void rebakeSleepingBag(class_10817.class_10818 builder, class_1058 sprite) {
            this.models.get((Object)ModelParts.SLEEPING_BAG).method_68048().forEach(quad -> {
                class_1058 oldSprite = quad.comp_3724();
                int[] oldData = quad.comp_3721();
                int[] newData = Arrays.copyOf(oldData, oldData.length);
                for (int i = 0; i < 4; ++i) {
                    int index = i * 8;
                    float oldU = Float.intBitsToFloat(oldData[index + 4]);
                    float oldV = Float.intBitsToFloat(oldData[index + 5]);
                    float uUn = oldSprite.method_35804(oldU);
                    float vUn = oldSprite.method_35805(oldV);
                    float newU = sprite.method_4580(uUn);
                    float newV = sprite.method_4570(vUn);
                    newData[index + 4] = Float.floatToRawIntBits(newU);
                    newData[index + 5] = Float.floatToRawIntBits(newV);
                    builder.method_68051(new class_777(newData, quad.comp_3722(), quad.comp_3723(), sprite, quad.comp_3725(), quad.comp_3726()));
                }
            });
        }

        private void addExtras(class_10817.class_10818 builder) {
            if (this.block == ModBlocks.FOX_TRAVELERS_BACKPACK) {
                DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.FOX_NOSE));
            }
            if (this.block == ModBlocks.WARDEN_TRAVELERS_BACKPACK) {
                DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.WARDEN_HORNS));
            }
            if (this.block == ModBlocks.WOLF_TRAVELERS_BACKPACK) {
                DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.WOLF_NOSE));
            }
            if (this.block == ModBlocks.OCELOT_TRAVELERS_BACKPACK) {
                DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.OCELOT_NOSE));
            }
            if (this.block == ModBlocks.PIG_TRAVELERS_BACKPACK || this.block == ModBlocks.HORSE_TRAVELERS_BACKPACK) {
                DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.PIG_NOSE));
            }
            if (this.block == ModBlocks.VILLAGER_TRAVELERS_BACKPACK || this.block == ModBlocks.IRON_GOLEM_TRAVELERS_BACKPACK) {
                DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.VILLAGER_NOSE));
            }
        }

        private Vector3f getVector(double x, double y, double z) {
            Vector3f ret = new Vector3f((float)x, (float)y, (float)z);
            this.rotate(ret, this.modelTransform.method_3509().method_22936());
            return ret;
        }

        private void rotate(Vector3f posIn, Matrix4fc transform) {
            Vector3f originIn = new Vector3f(0.5f, 0.5f, 0.5f);
            Vector4f vector4f = transform.transform(new Vector4f(posIn.x() - originIn.x(), posIn.y() - originIn.y(), posIn.z() - originIn.z(), 1.0f));
            posIn.set(vector4f.x() + originIn.x(), vector4f.y() + originIn.y(), vector4f.z() + originIn.z());
        }

        private int convertColorARGBtoABGR(int color) {
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            return a << 24 | b << 16 | g << 8 | r;
        }

        private class_777 createQuad(List<Vector3f> vectors, class_1058 sprite, class_2350 face, boolean hasAmbientOcclusion, int color, float u1x, float u2x, float v1x, float v2x, int tintIndex) {
            float u1 = sprite.method_4580(u1x /= 16.0f);
            float u2 = sprite.method_4580(u2x /= 16.0f);
            float v1 = sprite.method_4570(v1x /= 16.0f);
            float v2 = sprite.method_4570(v2x /= 16.0f);
            class_2382 normal = face.method_62675();
            int[] vertexData = new int[32];
            int packedColor = this.convertColorARGBtoABGR(color);
            for (int i = 0; i < 4; ++i) {
                int base = i * 8;
                Vector3f vec = vectors.get(i);
                vertexData[base] = Float.floatToRawIntBits(vec.x());
                vertexData[base + 1] = Float.floatToRawIntBits(vec.y());
                vertexData[base + 2] = Float.floatToRawIntBits(vec.z());
                vertexData[base + 3] = packedColor;
                float u = i == 0 || i == 1 ? u1 : u2;
                float v = i == 0 || i == 3 ? v1 : v2;
                vertexData[base + 4] = Float.floatToRawIntBits(u);
                vertexData[base + 5] = Float.floatToRawIntBits(v);
                vertexData[base + 6] = normal.method_10263();
                vertexData[base + 7] = normal.method_10264();
            }
            return new class_777(vertexData, tintIndex, face, sprite, hasAmbientOcclusion, 0);
        }

        public void method_68513(class_5819 randomSource, List<class_10889> list) {
        }

        private void collectParts(List<class_10889> parts) {
            class_10817.class_10818 builder = new class_10817.class_10818();
            this.addBaseBackpack(builder);
            this.addTanks(builder);
            this.addSleepingBag(builder);
            this.addExtras(builder);
            parts.add((class_10889)new class_10801(builder.method_68050(), true, this.particleIcon));
        }

        public void addBaseBackpack(class_10817.class_10818 builder) {
            if (this.isDyed && this.block == ModBlocks.STANDARD_TRAVELERS_BACKPACK) {
                DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.BASE_DYED));
                DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.EXTRAS));
            } else {
                DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.BASE));
            }
        }

        private void addTanks(class_10817.class_10818 builder) {
            if (this.renderInfo == null || !this.renderInfo.isEmpty()) {
                DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.TANKS));
                this.addFluids(builder, this.renderInfo);
            }
        }

        private void addFluids(class_10817.class_10818 builder, RenderInfo renderInfo) {
            if (renderInfo != null && !renderInfo.isEmpty()) {
                if (!renderInfo.getLeftFluidStack().isEmpty()) {
                    this.addFluid(builder, renderInfo.getLeftFluidStack(), (float)renderInfo.getLeftFluidStack().getAmount() / (float)renderInfo.getCapacity(), 0.1125f, 0);
                }
                if (!renderInfo.getRightFluidStack().isEmpty()) {
                    this.addFluid(builder, renderInfo.getRightFluidStack(), (float)renderInfo.getRightFluidStack().getAmount() / (float)renderInfo.getCapacity(), 0.79375f, 1);
                }
            }
        }

        private void addFluid(class_10817.class_10818 builder, FluidVariantWrapper fluidStack, float ratio, double xMin, int tintIndex) {
            if (fluidStack.isEmpty()) {
                return;
            }
            double yMin = 0.05;
            double yMax = yMin + (double)ratio * 6.2 / 16.0;
            class_238 bounds = new class_238(xMin, yMin, 0.39375, xMin + 0.09375, yMax, 0.4875);
            int color = FluidVariantRendering.getColor((FluidVariant)fluidStack.fluidVariant()) | 0xFF000000;
            class_1058 still = FluidVariantRendering.getSprite((FluidVariant)fluidStack.fluidVariant());
            float x1 = 0.0f;
            float x2 = 3.0f;
            float y1 = 0.0f;
            float y2 = ratio * 12.0f;
            float z1 = 0.0f;
            float z2 = 3.0f;
            builder.method_68051(this.createQuad(List.of(this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321), this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321)), still, class_2350.field_11036, false, color, x1, x2, z1, z2, tintIndex));
            builder.method_68051(this.createQuad(List.of(this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321), this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321)), still, class_2350.field_11043, false, color, x1, x2, y1, y2, tintIndex));
            builder.method_68051(this.createQuad(List.of(this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324)), still, class_2350.field_11035, false, color, x1, x2, y1, y2, tintIndex));
            builder.method_68051(this.createQuad(List.of(this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321), this.getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324), this.getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324)), still, class_2350.field_11039, false, color, z1, z2, y1, y2, tintIndex));
            builder.method_68051(this.createQuad(List.of(this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324), this.getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321), this.getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321)), still, class_2350.field_11034, false, color, z1, z2, y1, y2, tintIndex));
        }

        private void addSleepingBag(class_10817.class_10818 builder) {
            if (this.isSleepingBagDeployed) {
                return;
            }
            DynamicBlockStateModel.addAll(builder, this.models.get((Object)ModelParts.SLEEPING_BAG_EXTRAS));
            class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(class_2960.method_60655((String)"travelersbackpack", (String)("block/bag/" + class_1767.method_7791((int)this.sleepingBagColor).method_7792().toLowerCase(Locale.ENGLISH) + "_sleeping_bag")));
            this.rebakeSleepingBag(builder, sprite);
        }

        private static class_10817.class_10818 addAll(class_10817.class_10818 base, class_10817 collection) {
            for (class_2350 direction : class_2350.values()) {
                List quads = collection.method_68049(direction);
                for (class_777 quad : quads) {
                    base.method_68053(direction, quad);
                }
            }
            List unculledQuads = collection.method_68049(null);
            for (class_777 quad : unculledQuads) {
                base.method_68051(quad);
            }
            return base;
        }

        public List<class_777> getQuads() {
            ArrayList<class_10889> parts = new ArrayList<class_10889>();
            this.collectParts(parts);
            ArrayList<class_777> bakedQuads = new ArrayList<class_777>();
            for (class_10889 part : parts) {
                for (class_2350 dir : class_2350.values()) {
                    bakedQuads.addAll(part.method_68509(dir));
                }
                bakedQuads.addAll(part.method_68509(null));
            }
            return bakedQuads;
        }

        public class_1058 method_68511() {
            return this.particleIcon;
        }
    }

    private static enum ModelParts {
        BASE,
        BASE_DYED,
        EXTRAS,
        TANKS,
        SLEEPING_BAG,
        SLEEPING_BAG_EXTRAS,
        FOX_NOSE,
        OCELOT_NOSE,
        WOLF_NOSE,
        VILLAGER_NOSE,
        PIG_NOSE,
        WARDEN_HORNS;

    }

    public static final class Loader
    implements UnbakedModelDeserializer {
        public static final Loader INSTANCE = new Loader();
        private static Map<class_2960, class_11515> RENDER_TYPES;

        public class_1100 deserialize(JsonObject modelContents, JsonDeserializationContext context) {
            class_2960 particleTexture;
            class_2960 backpackTexture;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            class_10419.class_10420.class_10421 texturesBuilder = new class_10419.class_10420.class_10421();
            if (modelContents.has("backpackTexture") && (backpackTexture = class_2960.method_12829((String)modelContents.get("backpackTexture").getAsString())) != null) {
                texturesBuilder.method_65548("0", new class_4730(class_1059.field_5275, backpackTexture));
            }
            if (modelContents.has("particle") && (particleTexture = class_2960.method_12829((String)modelContents.get("particle").getAsString())) != null) {
                texturesBuilder.method_65548("particle", new class_4730(class_1059.field_5275, particleTexture));
            }
            texturesBuilder.method_65548("missing", new class_4730(class_1059.field_5275, class_1047.method_4539()));
            class_11515 renderTypeGroup = Loader.deserializeRenderType(modelContents);
            for (ModelParts part : ModelParts.values()) {
                this.addPartModel((ImmutableMap.Builder<ModelParts, class_793>)builder, part, texturesBuilder.method_65547());
            }
            return new BackpackDynamicModel((Map<ModelParts, class_793>)builder.build(), renderTypeGroup);
        }

        private void addPartModel(ImmutableMap.Builder<ModelParts, class_793> builder, ModelParts modelPart, class_10419.class_10420 textures) {
            builder.put((Object)modelPart, (Object)new class_793(null, null, Boolean.valueOf(true), class_809.field_4301, textures, class_2960.method_60655((String)"travelersbackpack", (String)("block/backpack_" + modelPart.name().toLowerCase(Locale.ENGLISH)))));
        }

        public static class_11515 deserializeRenderType(JsonObject jsonObject) {
            if (jsonObject.has("render_type")) {
                String renderTypeHintName = class_3518.method_15265((JsonObject)jsonObject, (String)"render_type");
                return RENDER_TYPES.get(class_2960.method_60654((String)renderTypeHintName));
            }
            return class_11515.field_60923;
        }

        public static void loadVanillaRenderTypes() {
            RENDER_TYPES = new HashMap<class_2960, class_11515>();
            RENDER_TYPES.put(class_2960.method_60656((String)"solid"), class_11515.field_60923);
            RENDER_TYPES.put(class_2960.method_60656((String)"cutout"), class_11515.field_60925);
            RENDER_TYPES.put(class_2960.method_60656((String)"cutout_mipped"), class_11515.field_60924);
            RENDER_TYPES.put(class_2960.method_60656((String)"cutout_mipped_all"), class_11515.field_60924);
            RENDER_TYPES.put(class_2960.method_60656((String)"translucent"), class_11515.field_60926);
            RENDER_TYPES.put(class_2960.method_60656((String)"tripwire"), class_11515.field_60927);
        }
    }

    public record UnbakedBlockStateModel(class_813 variant) implements CustomUnbakedBlockStateModel
    {
        public static final MapCodec<UnbakedBlockStateModel> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_813.field_57947.forGetter(UnbakedBlockStateModel::variant)).apply((Applicative)instance, UnbakedBlockStateModel::new));
        public static final class_2960 ID = class_2960.method_60655((String)"travelersbackpack", (String)"backpack_loader");

        public class_1087 method_68521(class_7775 modelBaker) {
            class_10819 resolvedModel = modelBaker.method_45872(this.variant.comp_3379());
            class_1100 class_11002 = resolvedModel.method_68031();
            if (class_11002 instanceof BackpackDynamicModel) {
                BackpackDynamicModel model = (BackpackDynamicModel)class_11002;
                return model.bakeBlockStateModel(modelBaker, resolvedModel, this.variant.comp_3754().method_67943());
            }
            throw new IllegalStateException("Expected BackpackDynamicModel, instead received " + resolvedModel.method_68031().getClass().getName());
        }

        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(this.variant.comp_3379());
        }

        public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
            return CODEC;
        }
    }
}

