/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.buttons;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.Button;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class AbilitySliderButton
extends Button {
    private final boolean isBlock;

    public AbilitySliderButton(BackpackScreen screen, boolean isBlock, int xOffset) {
        super(screen, screen.getWidthAdditions() + 145 - xOffset, screen.getMiddleBar(), 12, 12);
        this.isBlock = isBlock;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isBlock) {
            this.drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS);
        } else if (ComponentUtils.isWearingBackpack(((BackpackBaseMenu)this.screen.method_17577()).getPlayerInventory().field_7546)) {
            this.drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS);
        }
    }

    public void drawButton(class_332 guiGraphics, int mouseX, int mouseY, class_2960 texture) {
        if (this.screen.getWrapper().isAbilityEnabled()) {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 44, 56, 78, 82);
        } else {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 44, 67, 78, 82);
        }
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.inButton(mouseX, mouseY)) {
            if (!BackpackAbilities.isAbilityEnabledInConfig(this.screen.getWrapper().getBackpackStack())) {
                guiGraphics.method_51438(this.screen.method_64506(), (class_2561)class_2561.method_43471((String)"screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
                return;
            }
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            if (this.screen.getWrapper().isAbilityEnabled()) {
                components.add(class_2561.method_43471((String)"screen.travelersbackpack.ability_enabled"));
            } else {
                components.add(class_2561.method_43471((String)"screen.travelersbackpack.ability_disabled"));
            }
            if (BackpackAbilities.hasCooldown(this.screen.getWrapper().getBackpackStack())) {
                components.add(class_2561.method_43469((String)"screen.travelersbackpack.ability_cooldown", (Object[])new Object[]{TextUtils.getConvertedTime(this.screen.getWrapper().getCooldown())}));
            } else {
                components.add(class_2561.method_43471((String)"screen.travelersbackpack.ability_ready"));
            }
            guiGraphics.method_64038(this.screen.method_64506(), components, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities || !BackpackAbilities.isAbilityEnabledInConfig(this.screen.getWrapper().getBackpackStack())) {
            return false;
        }
        if (this.isBlock) {
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack()) && this.inButton((int)mouseX, (int)mouseY)) {
                ServerboundActionTagPacket.create(14, !this.screen.getWrapper().isAbilityEnabled());
                this.screen.playUIClickSound();
                return true;
            }
        } else if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack()) && this.inButton((int)mouseX, (int)mouseY)) {
            ServerboundActionTagPacket.create(14, !this.screen.getWrapper().isAbilityEnabled());
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }
}

