/*
 * Decompiled with CFR 0.152.
 */
package net.digitalpear.gipples_galore.common.datagens;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.digitalpear.gipples_galore.init.GGBlocks;
import net.digitalpear.gipples_galore.init.GGEntityTypes;
import net.digitalpear.gipples_galore.init.GGItems;
import net.digitalpear.gipples_galore.init.artsy_stuff.GGJukeboxSongs;
import net.digitalpear.gipples_galore.init.data.sets.StoneSet;
import net.digitalpear.gipples_galore.init.tags.GGBiomeTags;
import net.digitalpear.gipples_galore.init.tags.GGBlockTags;
import net.digitalpear.gipples_galore.init.tags.GGItemTags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9793;

public class GGLanguageProvider
extends FabricLanguageProvider {
    public GGLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (class_2248 jelly : GGBlocks.JELLY.keySet()) {
            this.autoName(translationBuilder, jelly);
        }
        translationBuilder.add(GGBlocks.GELATIN_BLOCK, "Block of Gelatin");
        this.autoName(translationBuilder, GGBlocks.GELATINOUS_GROWTH);
        this.autoName(translationBuilder, GGBlocks.GELATITE_SET);
        this.makeLoreTranslation(translationBuilder, "A fusion of gelatin and stone, great for building.", GGBlocks.GELATITE_SET);
        this.autoName(translationBuilder, GGBlocks.GELATITE_BRICK_SET);
        this.makeLoreTranslation(translationBuilder, "A fusion of gelatin and deepslate, great for building.", GGBlocks.GELATITE_BRICK_SET);
        this.autoName(translationBuilder, GGBlocks.AMOEBALITH_SET);
        this.makeLoreTranslation(translationBuilder, "A fusion of gelatin and deepslate, great for building.", GGBlocks.AMOEBALITH_SET);
        this.autoName(translationBuilder, GGBlocks.AMOEBALITH_BRICK_SET);
        this.makeLoreTranslation(translationBuilder, "A fusion of gelatin and deepslate, great for building.", GGBlocks.AMOEBALITH_BRICK_SET);
        this.autoName(translationBuilder, GGBlocks.GELATIN_LAYER);
        this.autoName(translationBuilder, (class_1935)GGBlocks.GIPPLEPAD, "???");
        this.autoName(translationBuilder, GGEntityTypes.GIPPLE);
        this.autoName(translationBuilder, GGEntityTypes.ANEUPLOIDIAN);
        this.autoName(translationBuilder, GGBlocks.HIBERNATING_GIPPLE);
        this.makeLoreTranslation(translationBuilder, (class_1935)GGBlocks.HIBERNATING_GIPPLE, "Contains a hibernating gipple which can be woken up by breaking the block.");
        this.autoName(translationBuilder, (class_1935)GGItems.GELATIN, "What gipples are made of. Very delicious and useful for building.");
        this.autoName(translationBuilder, (class_1935)GGItems.GAPPLE, "Eating is not advised.");
        translationBuilder.add(GGItems.GIPPLE_BUCKET, "Bucket of Gipple");
        translationBuilder.add(GGItems.GIPPLE_SPAWN_EGG, "Gipple Spawn Egg");
        translationBuilder.add(GGItems.ANEUPLOIDIAN_SPAWN_EGG, "Aneuploidian Spawn Egg");
        translationBuilder.add(GGItems.MUSIC_DISC_GIPPLECORE, "Music Disc");
        GGLanguageProvider.jukeboxSongTranslation(translationBuilder, GGJukeboxSongs.GIPPLECORE, "Axoladdy - gipplecore");
        this.makeBannerTranslation(translationBuilder, GGItems.GIPPLE_BANNER_PATTERN, "Gipple");
        translationBuilder.add("advancements.husbandry.jellies.title", "Sing a rainbow!");
        translationBuilder.add("advancements.husbandry.jellies.description", "Have one of all jelly flavours in your inventory.");
        translationBuilder.add("advancements.husbandry.affordable_housing.title", "Affordable Housing!");
        translationBuilder.add("advancements.husbandry.affordable_housing.description", "Have the Infested, Oozing and Gipple status effects applied at the same time.");
        translationBuilder.add("subtitles.gipples_galore.gipple.ambient", "Gipple vibrates");
        translationBuilder.add("subtitles.gipples_galore.gipple.hurt", "Gipple hurts");
        translationBuilder.add("subtitles.gipples_galore.gipple.burp", "Gipple consumes");
        translationBuilder.add("subtitles.gipples_galore.gipple.death", "Gipple dies");
        translationBuilder.add("subtitles.gipples_galore.aneuploidian.ambient", "Aneuploidian vibrates");
        translationBuilder.add("subtitles.gipples_galore.aneuploidian.hurt", "Aneuploidian hurts");
        translationBuilder.add("subtitles.gipples_galore.aneuploidian.death", "Aneuploidian dies");
        translationBuilder.add("death.attack.gippleEffect", "%s was gipplified");
        translationBuilder.add("death.attack.gippleEffect.player", "%s became a Gipple to get away from %s");
        translationBuilder.add("effect.gipples_galore.gipple", "Gipple");
        translationBuilder.add("effect.gipples_galore.gipple.description", "Will slowly turn the host into a gipple. Side effects may include auditory hallucinations.");
        translationBuilder.add("painting.gipples_galore.gipple.title", "Gipple");
        translationBuilder.add("painting.gipples_galore.gipple.author", "Yapettoshen");
        this.nameTag(translationBuilder, GGBiomeTags.EXTRA_GIPPLE_HABITATS);
        this.nameTag(translationBuilder, GGBlockTags.GELATINOUS_GROWTH_SUPPORTING);
        this.nameTag(translationBuilder, GGBlockTags.GIPPLE_FOOD);
        this.nameTag(translationBuilder, GGItemTags.GIPPLE_FOOD);
        this.nameTag(translationBuilder, GGBlockTags.JELLIES);
        translationBuilder.add("gamerule.doApplyJellyEffects", "Should apply jelly effects when eaten.");
        translationBuilder.add("gamerule.gippleMutationPercentage", "Percentage chance for gipples to mutate when splitting.");
    }

    private void makeLoreTranslation(FabricLanguageProvider.TranslationBuilder translationBuilder, String lore, StoneSet set) {
        set.getBlockFamily().method_33474().values().forEach(block -> this.makeLoreTranslation(translationBuilder, (class_1935)block.method_8389(), lore));
    }

    private void makeLoreTranslation(FabricLanguageProvider.TranslationBuilder translationBuilder, class_1935 item, String lore) {
        translationBuilder.add("lore." + class_7923.field_41178.method_10221((Object)item.method_8389()).method_42094(), lore);
    }

    private void makeBannerTranslation(FabricLanguageProvider.TranslationBuilder translationBuilder, class_1792 item, String name) {
        translationBuilder.add(item, name + " Banner Pattern");
        this.makeColoredBannerPatterns(translationBuilder, name);
    }

    private void makeColoredBannerPatterns(FabricLanguageProvider.TranslationBuilder translationBuilder, String name) {
        Arrays.stream(class_1767.values()).toList().forEach(color -> translationBuilder.add("block.gipples_galore.banner.gipples_galore." + name.toLowerCase() + "." + color.method_7792(), this.autoNameInner(color.method_7792()) + " " + name));
    }

    private static void jukeboxSongTranslation(FabricLanguageProvider.TranslationBuilder translationBuilder, class_5321<class_9793> song, String value) {
        translationBuilder.add("jukebox_song." + song.method_29177().method_42094(), value);
    }

    private void autoName(FabricLanguageProvider.TranslationBuilder translationBuilder, StoneSet set) {
        this.autoName(translationBuilder, set.getBase());
        set.getBlockFamily().method_33474().values().forEach(block -> this.autoName(translationBuilder, (class_2248)block));
    }

    private void autoName(FabricLanguageProvider.TranslationBuilder translationBuilder, class_2248 block) {
        translationBuilder.add(block, this.autoNameInner(class_7923.field_41175.method_10221((Object)block).method_12832()));
    }

    private void autoName(FabricLanguageProvider.TranslationBuilder translationBuilder, class_1792 item) {
        translationBuilder.add(item, this.autoNameInner(class_7923.field_41178.method_10221((Object)item).method_12832()));
    }

    private void autoName(FabricLanguageProvider.TranslationBuilder translationBuilder, class_1299<?> entityType) {
        translationBuilder.add(entityType, this.autoNameInner(class_7923.field_41177.method_10221(entityType).method_12832()));
    }

    private void autoName(FabricLanguageProvider.TranslationBuilder translationBuilder, class_1935 convertible, String lore) {
        this.makeLoreTranslation(translationBuilder, convertible, lore);
        this.autoName(translationBuilder, convertible.method_8389());
    }

    private void nameTag(FabricLanguageProvider.TranslationBuilder translationBuilder, class_6862<?> tTagKey) {
        translationBuilder.add(tTagKey, this.autoNameInner(tTagKey.comp_327().method_12832()));
    }

    private String autoNameInner(String id) {
        String[] split;
        StringBuilder name = new StringBuilder();
        for (String str : split = id.split("_")) {
            if (!name.isEmpty()) {
                name.append(" ");
            }
            name.append(GGLanguageProvider.capitalize(str));
        }
        return name.toString();
    }

    public static String capitalize(String inputString) {
        char firstLetter = inputString.charAt(0);
        return inputString.replaceFirst(String.valueOf(firstLetter), String.valueOf(firstLetter).toUpperCase());
    }
}

