/*
 * Decompiled with CFR 0.152.
 */
package net.digitalpear.gipples_galore.common.entities.gipple;

import java.util.EnumSet;
import net.digitalpear.gipples_galore.init.GGBlocks;
import net.digitalpear.gipples_galore.init.GGDataComponentTypes;
import net.digitalpear.gipples_galore.init.GGEntityTypes;
import net.digitalpear.gipples_galore.init.GGGameRules;
import net.digitalpear.gipples_galore.init.GGItems;
import net.digitalpear.gipples_galore.init.GGSoundEvents;
import net.digitalpear.gipples_galore.init.GGStatusEffects;
import net.digitalpear.gipples_galore.init.tags.GGBlockTags;
import net.digitalpear.gipples_galore.init.tags.GGItemTags;
import net.minecraft.class_10179;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1367;
import net.minecraft.class_1374;
import net.minecraft.class_1391;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5530;
import net.minecraft.class_5533;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GippleEntity
extends class_1296
implements class_5761,
GeoEntity,
class_1432 {
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(GippleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_DANCING = class_2945.method_12791(GippleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_LUMINOUS = class_2945.method_12791(GippleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_EATING = class_2945.method_12791(GippleEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> HUNGRY_COUNTDOWN = class_2945.method_12791(GippleEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> EATING_TIMER = class_2945.method_12791(GippleEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> PLACE_GELATIN_TIMER = class_2945.method_12791(GippleEntity.class, (class_2941)class_2943.field_13327);
    private final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation DANCING_ANIM = RawAnimation.begin().thenLoop("gipple.dance");
    protected static final RawAnimation EATING_ANIM = RawAnimation.begin().thenPlay("gipple.eat");
    protected static final RawAnimation AMBIENT_ANIM = RawAnimation.begin().thenLoop("gipple.ambient");
    protected static final RawAnimation ON_GROUND_ANIM = RawAnimation.begin().thenLoop("gipple.floor");
    public static float INFLATED_SCALE = 1.3f;
    public static float BABY_SCALE = 0.8f;

    public GippleEntity(class_1299<? extends GippleEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 5;
        this.field_6207 = new class_1331((class_1308)this, 10, true);
    }

    public static class_5132.class_5133 createGippleAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_52450, 10.0).method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23720, 0.4).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23718, 0.2);
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        return world.method_8320(pos).method_26215() || world.method_8320(pos).method_26164(GGBlockTags.GIPPLE_FOOD) ? 10.0f : 0.0f;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new FindAndEatFoodGoal(this, 1.2, 10, 5));
        this.field_6201.method_6277(0, (class_1352)new FindBlockAndPlaceGelatinGoal(this, 1.2, 10, 2));
        this.field_6201.method_6277(2, (class_1352)new GippleFlyAroundGoal());
        this.field_6201.method_6277(3, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(1, (class_1352)new GippleTemptGoal(this, GGItemTags.GIPPLE_FOOD));
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world);
        birdNavigation.method_70687(false);
        birdNavigation.method_6354(false);
        return birdNavigation;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)GGEntityTypes.GIPPLE.method_5883((class_1937)world, class_3730.field_16466);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_DANCING, (Object)false);
        builder.method_56912(IS_LUMINOUS, (Object)false);
        builder.method_56912(FROM_BUCKET, (Object)false);
        builder.method_56912(IS_EATING, (Object)false);
        builder.method_56912(HUNGRY_COUNTDOWN, (Object)this.genRandomHungryCountdown());
        builder.method_56912(EATING_TIMER, (Object)40);
        builder.method_56912(PLACE_GELATIN_TIMER, (Object)300);
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        nbt.method_71472("FromBucket", this.method_6453());
        nbt.method_71472("Dancing", this.isDancing());
        nbt.method_71472("Eating", this.isEating());
        nbt.method_71472("Luminous", this.isLuminous());
        nbt.method_71465("hungryCountdown", this.getHungryCountdown());
        nbt.method_71465("eatingTimer", this.getEatingTimer());
        nbt.method_71465("placeGelatinTimer", this.getPlaceGelatinTimer());
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        this.method_6454(nbt.method_71433("FromBucket", false));
        this.setDancing(nbt.method_71433("Dancing", false));
        this.setEating(nbt.method_71433("Eating", false));
        this.setLuminous(nbt.method_71433("Luminous", false));
        this.setHungryCountdown(nbt.method_71424("hungryCountdown", 0));
        this.setEatingTimer(nbt.method_71424("eatingTimer", 0));
        this.setPlaceGelatinTimer(nbt.method_71424("placeGelatinTimer", 0));
    }

    public void method_5773() {
        super.method_5773();
        if (this.getHungryCountdown() != 0 && !this.isLuminous() && !this.method_6109()) {
            this.setHungryCountdown(this.getHungryCountdown() - 1);
        }
        if (this.getEatingTimer() != 0 && !this.isLuminous() && this.isEating()) {
            this.setEatingTimer(this.getEatingTimer() - 1);
        }
        if (this.getPlaceGelatinTimer() != 0 && this.isLuminous()) {
            this.setPlaceGelatinTimer(this.getPlaceGelatinTimer() - 1);
        }
    }

    public int genRandomHungryCountdown() {
        return this.field_5974.method_39332(400, 1000);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (itemInHand.method_31574(class_1802.field_8705)) {
            player.method_6104(hand);
            this.method_5932();
            class_5761.method_35169((class_1657)player, (class_1268)hand, (class_1309)this);
        } else if (itemInHand.method_31573(GGItemTags.GIPPLE_FOOD)) {
            if (!this.method_6109()) {
                if (!this.isLuminous()) {
                    if (this.getHungryCountdown() == 0) {
                        this.setLuminous(true);
                        this.setHungryCountdown(this.genRandomHungryCountdown());
                    }
                    return class_1269.field_5811;
                }
            } else {
                this.method_5620(class_1429.method_41321((int)(-this.method_5618())), true);
                return class_1269.field_52422.method_61394();
            }
            this.mitosis();
            if (!player.method_31549().field_7477) {
                itemInHand.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void mitosis() {
        class_5819 random = this.method_59922();
        class_1937 world = this.method_37908();
        if (world instanceof class_3218) {
            boolean spawnAneuploidianNotGipple;
            class_3218 serverWorld = (class_3218)world;
            boolean bl = spawnAneuploidianNotGipple = (double)serverWorld.method_64395().method_8356(GGGameRules.GIPPLE_MUTATION) * 0.01 + (double)((float)world.method_8407().method_5461() / 50.0f) > (double)random.method_43057() && world.method_8407() != class_1267.field_5801;
            if (spawnAneuploidianNotGipple) {
                this.spawnAneuploidian();
            } else {
                this.method_5932();
                int gippleNumber = 2;
                if ((double)random.method_43057() > 0.9) {
                    ++gippleNumber;
                }
                for (int i = 0; i < gippleNumber; ++i) {
                    this.spawnGipple(random);
                }
            }
        }
        for (int particleLoop = 0; particleLoop <= 5; ++particleLoop) {
            double x = random.method_43059() * 0.001;
            double y = random.method_43059() * 0.06;
            double z = random.method_43059() * 0.001;
            world.method_8406((class_2394)class_2398.field_17741, this.method_23317() + 0.5, this.method_23318() + 0.5, this.method_23321() + 0.5, x, y, z);
        }
        world.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_20610, class_3419.field_15254, 1.0f, 1.0f);
        this.method_31472();
    }

    public void spawnAneuploidian() {
        this.method_29243(GGEntityTypes.ANEUPLOIDIAN, class_10179.method_63607((class_1308)this, (boolean)false, (boolean)true), class_1308::method_5971);
    }

    public void spawnGipple(class_5819 random) {
        GippleEntity gipple = (GippleEntity)GGEntityTypes.GIPPLE.method_5883(this.method_37908(), class_3730.field_16468);
        if (gipple != null) {
            gipple.method_5971();
            gipple.method_66649((class_9473)this);
            gipple.method_7217(true);
            gipple.setLuminous(false);
            gipple.method_5808(this.method_23317() + random.method_43058(), this.method_23318() + random.method_43058(), this.method_23321() - random.method_43058(), 0.0f, 0.0f);
            this.method_37908().method_8649((class_1297)gipple);
        }
    }

    public boolean method_5747(double fallDistance, float damagePerDistance, class_1282 damageSource) {
        return false;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    public boolean method_5740() {
        return true;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    public boolean isDancing() {
        return (Boolean)this.field_6011.method_12789(IS_DANCING);
    }

    public void setDancing(boolean value) {
        this.field_6011.method_12778(IS_DANCING, (Object)value);
    }

    public boolean isEating() {
        return (Boolean)this.field_6011.method_12789(IS_EATING);
    }

    public void setEating(boolean value) {
        this.field_6011.method_12778(IS_EATING, (Object)value);
    }

    public boolean isLuminous() {
        return (Boolean)this.field_6011.method_12789(IS_LUMINOUS);
    }

    public void setLuminous(boolean value) {
        this.field_6011.method_12778(IS_LUMINOUS, (Object)value);
    }

    public int getHungryCountdown() {
        return (Integer)this.field_6011.method_12789(HUNGRY_COUNTDOWN);
    }

    public void setHungryCountdown(int value) {
        this.field_6011.method_12778(HUNGRY_COUNTDOWN, (Object)value);
    }

    public int getEatingTimer() {
        return (Integer)this.field_6011.method_12789(EATING_TIMER);
    }

    public void setEatingTimer(int value) {
        this.field_6011.method_12778(EATING_TIMER, (Object)value);
    }

    public int getPlaceGelatinTimer() {
        return (Integer)this.field_6011.method_12789(PLACE_GELATIN_TIMER);
    }

    public void setPlaceGelatinTimer(int value) {
        this.field_6011.method_12778(PLACE_GELATIN_TIMER, (Object)value);
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public void method_6455(class_1799 stack) {
        class_5761.method_35167((class_1308)this, (class_1799)stack);
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, nbtCompound -> {
            if (this.method_5987()) {
                nbtCompound.method_10556("NoAI", this.method_5987());
            }
            if (this.method_5701()) {
                nbtCompound.method_10556("Silent", this.method_5701());
            }
            if (this.method_5740()) {
                nbtCompound.method_10556("NoGravity", this.method_5740());
            }
            if (this.method_5655()) {
                nbtCompound.method_10556("Invulnerable", this.method_5655());
            }
            nbtCompound.method_10548("Health", this.method_6032());
            nbtCompound.method_10569("Age", this.method_5618());
            nbtCompound.method_10556("Luminous", this.isLuminous());
            nbtCompound.method_10569("HungryCountdown", this.getHungryCountdown());
            nbtCompound.method_10569("EatingTimer", this.getEatingTimer());
            nbtCompound.method_10569("PlaceGelatinTimer", this.getPlaceGelatinTimer());
        });
    }

    public float method_17825() {
        if (this.isLuminous()) {
            return INFLATED_SCALE;
        }
        return this.method_6109() ? BABY_SCALE : super.method_17825();
    }

    public void method_35170(class_2487 nbt) {
        nbt.method_10550("Age").ifPresent(arg_0 -> ((GippleEntity)this).method_5614(arg_0));
        nbt.method_10550("HungryCountdown").ifPresent(this::setHungryCountdown);
        nbt.method_10550("PlaceGelatinTimer").ifPresent(this::setPlaceGelatinTimer);
        nbt.method_10550("EatingTimer").ifPresent(this::setEatingTimer);
        nbt.method_10577("Luminous").ifPresent(this::setLuminous);
        this.method_6454(true);
        class_5761.method_35168((class_1308)this, (class_2487)nbt);
    }

    protected void method_66649(class_9473 from) {
        super.method_66649(from);
        this.method_66650(from, GGDataComponentTypes.LUMINOUS);
    }

    protected <T> boolean method_66654(class_9331<T> type, T value) {
        if (type == GGDataComponentTypes.LUMINOUS) {
            this.setLuminous((Boolean)GippleEntity.method_66651(GGDataComponentTypes.LUMINOUS, value));
            return true;
        }
        return super.method_66654(type, value);
    }

    @Nullable
    public <T> T method_58694(class_9331<? extends T> type) {
        return (T)(type == GGDataComponentTypes.LUMINOUS ? GippleEntity.method_66651(type, (Object)this.isLuminous()) : super.method_58694(type));
    }

    public class_3414 method_35171() {
        return class_3417.field_14568;
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)GGItems.GIPPLE_BUCKET);
    }

    public boolean method_6049(class_1293 effect) {
        return effect.method_5579() != GGStatusEffects.GIPPLE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController(animationTest -> {
            if (!((GippleEntity)animationTest.animatable()).isDancing()) {
                if (this.isEating()) {
                    return animationTest.setAndContinue(EATING_ANIM);
                }
                if (this.method_24828()) {
                    return animationTest.setAndContinue(ON_GROUND_ANIM);
                }
                return animationTest.setAndContinue(AMBIENT_ANIM);
            }
            animationTest.setAndContinue(DANCING_ANIM);
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }

    public double getTick(Object object) {
        return this.field_6012;
    }

    @Nullable
    protected class_3414 method_6002() {
        return GGSoundEvents.ENTITY_GIPPLE_DEATH;
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)GGSoundEvents.ENTITY_GIPPLE_AMBIENT.comp_349();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return GGSoundEvents.ENTITY_GIPPLE_HURT;
    }

    public boolean method_24828() {
        return this.method_37908().method_8320(this.method_24515().method_10074()).method_26168((class_1922)this.method_37908(), this.method_24515().method_10074(), (class_1297)this);
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (spawnReason.equals((Object)class_3730.field_16473)) {
            this.method_5971();
            this.method_6454(true);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)this.method_5751() * 0.6, (double)this.method_17681() * 0.1);
    }

    public static class FindAndEatFoodGoal
    extends class_1367 {
        public final GippleEntity mob;

        public FindAndEatFoodGoal(GippleEntity mob, double speed, int range, int maxYDifference) {
            super((class_1314)mob, speed, range, maxYDifference);
            this.mob = mob;
        }

        public boolean method_6264() {
            return this.mob.getHungryCountdown() == 0 && !this.mob.isLuminous() && !this.mob.method_6109() && super.method_6264();
        }

        protected class_2338 method_30953() {
            return this.field_6512;
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            return world.method_8320(pos).method_26164(GGBlockTags.GIPPLE_FOOD);
        }

        public boolean method_6266() {
            return !this.mob.isLuminous() && super.method_6266();
        }

        public void method_6268() {
            if (this.method_6295()) {
                this.mob.setEating(true);
                if (this.mob.getEatingTimer() == 0) {
                    if (this.mob.field_5974.method_39332(0, 3) == 0) {
                        this.mob.method_37908().method_22352(this.method_30953(), false);
                    }
                    if ((double)this.mob.method_59922().method_43057() < 0.5) {
                        this.mob.method_56078(GGSoundEvents.ENTITY_GIPPLE_BURP);
                    }
                    this.mob.setEating(false);
                    this.mob.setLuminous(true);
                }
            } else {
                this.mob.setEating(false);
            }
            super.method_6268();
        }

        public void method_6270() {
            this.mob.setEatingTimer(40);
            this.mob.setHungryCountdown(this.mob.genRandomHungryCountdown());
            super.method_6270();
        }
    }

    public static class FindBlockAndPlaceGelatinGoal
    extends class_1367 {
        public final GippleEntity mob;

        public FindBlockAndPlaceGelatinGoal(GippleEntity mob, double speed, int range, int maxYDifference) {
            super((class_1314)mob, speed, range, maxYDifference);
            this.mob = mob;
        }

        public boolean method_6264() {
            return this.mob.getPlaceGelatinTimer() == 0 && this.mob.isLuminous() && !this.mob.method_6109() && super.method_6264();
        }

        public boolean method_6266() {
            return this.mob.isLuminous() && super.method_6266();
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            return world.method_8320(pos).method_26164(class_3481.field_25806) && world.method_8320(pos.method_10084()).method_26215();
        }

        public void method_6268() {
            if (this.method_6295()) {
                this.mob.method_37908().method_8501(this.field_6512.method_10084(), GGBlocks.GELATIN_LAYER.method_9564());
                this.mob.setLuminous(false);
            }
            super.method_6268();
        }

        public void method_6270() {
            super.method_6270();
            this.mob.setPlaceGelatinTimer(300);
        }
    }

    class GippleFlyAroundGoal
    extends class_1352 {
        public final GippleEntity mob;

        GippleFlyAroundGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.mob = GippleEntity.this;
        }

        public boolean method_6264() {
            return this.mob.field_6189.method_6357() && this.mob.field_5974.method_43048(10) == 0;
        }

        public boolean method_6266() {
            return this.mob.field_6189.method_23966();
        }

        public void method_6269() {
            class_243 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                this.mob.field_6189.method_6334(this.mob.field_6189.method_6348(class_2338.method_49638((class_2374)vec3d), 1), 1.0);
            }
        }

        @Nullable
        private class_243 getRandomLocation() {
            class_243 vec3d2 = this.mob.method_5828(0.0f);
            class_243 vec3d3 = class_5533.method_31524((class_1314)this.mob, (int)8, (int)7, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (float)1.5707964f, (int)3, (int)1);
            if (vec3d3 != null) {
                return vec3d3;
            }
            return class_5530.method_31504((class_1314)this.mob, (int)8, (int)4, (int)-2, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (double)1.5707963705062866);
        }
    }

    static class GippleTemptGoal
    extends class_1391 {
        public final GippleEntity mob;

        public GippleTemptGoal(GippleEntity mob, class_6862<class_1792> tagKey) {
            super((class_1314)mob, 1.25, stack -> stack.method_31573(tagKey), false);
            this.mob = mob;
        }

        public boolean method_6264() {
            return this.mob.getHungryCountdown() == 0 && super.method_6264();
        }

        public boolean method_6266() {
            return this.mob.getHungryCountdown() == 0 && super.method_6266();
        }
    }
}

