/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_2248;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_58;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7701;
import net.minecraft.class_7784;
import net.minecraft.class_7788;
import net.minecraft.class_7789;
import net.minecraft.class_7791;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8564;
import net.minecraft.class_8942;
import net.minecraft.class_9248;
import org.apache.commons.lang3.StringUtils;

public final class AbstractLootProvider {
    private AbstractLootProvider() {
    }

    public static interface LootTableDataProvider
    extends class_2405,
    class_7791 {
        public class_7225.class_7874 registries();

        public class_7784.class_7489 pathProvider();

        public class_176 paramSet();

        public boolean skipValidationFor(class_5321<class_52> var1);

        default public CompletableFuture<?> run(class_7403 output, class_7225.class_7874 registries) {
            class_2348 registry = new class_2348("empty", class_7924.field_50079, Lifecycle.experimental(), false);
            class_5321 defaultKey = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)registry.method_10137());
            registry.method_10272(defaultKey, (Object)class_52.field_948, class_9248.field_49136);
            Object2ObjectOpenHashMap seeds = new Object2ObjectOpenHashMap();
            this.method_10399((arg_0, arg_1) -> this.lambda$run$0((Map)seeds, registry, arg_0, arg_1));
            registry.method_40276();
            this.validate((class_2378<class_52>)registry);
            return CompletableFuture.allOf((CompletableFuture[])registry.method_29722().stream().filter(entry -> entry.getKey() != defaultKey).map(entry -> {
                class_5321 resourceKey = (class_5321)entry.getKey();
                class_52 lootTable = (class_52)entry.getValue();
                Path path = this.pathProvider().method_44107(resourceKey.method_29177());
                return class_2405.method_53496((class_7403)output, (class_7225.class_7874)registries, (Codec)class_52.field_50021, (Object)lootTable, (Path)path);
            }).toArray(CompletableFuture[]::new));
        }

        default public void validate(class_2378<class_52> registry) {
            class_8942.class_8943 collector = new class_8942.class_8943();
            class_5455.class_6890 registries = new class_5455.class_6891(List.of(registry)).method_40316();
            class_58 validationContext = new class_58((class_8942)collector, class_173.field_1177, (class_7871.class_7872)registries);
            registry.method_42017().forEach(holder -> this.validate((class_6880.class_6883<class_52>)holder, validationContext));
            if (!collector.method_71349()) {
                collector.method_71350((string, problem) -> field_40831.warn("Found validation problem in {}: {}", string, (Object)problem.method_71358()));
                throw new IllegalStateException("Failed to validate loot tables, see logs");
            }
        }

        default public void validate(class_6880.class_6883<class_52> holder, class_58 validationContext) {
            if (!this.skipValidationFor((class_5321<class_52>)holder.method_40237())) {
                ((class_52)holder.comp_349()).method_330(validationContext.method_22568(((class_52)holder.comp_349()).method_322()).method_51219((class_8942.class_11336)new class_8942.class_11338(holder.method_40237()), holder.method_40237()));
            }
        }

        private /* synthetic */ void lambda$run$0(Map seeds, class_2348 registry, class_5321 resourceKey, class_52.class_53 builder) {
            class_2960 resourceLocation = resourceKey.method_29177();
            class_2960 oldResourceLocation = seeds.put(class_8564.method_52171((class_2960)resourceLocation), resourceLocation);
            if (oldResourceLocation != null) {
                class_156.method_33559((String)("Loot table random sequence seed collision on " + String.valueOf(oldResourceLocation) + " and " + String.valueOf(resourceKey)));
            }
            builder.method_51883(resourceLocation);
            class_52 lootTable = builder.method_334(this.paramSet()).method_338();
            registry.method_10272(resourceKey, (Object)lootTable, class_9248.field_49136);
        }
    }

    public static abstract class Simple
    implements LootTableDataProvider {
        private final Map<class_5321<class_52>, class_52.class_53> values = new LinkedHashMap<class_5321<class_52>, class_52.class_53>();
        private final Set<class_5321<class_52>> skipValidation = new HashSet<class_5321<class_52>>();
        private final class_176 paramSet;
        private final class_7784.class_7489 pathProvider;
        private final CompletableFuture<class_7225.class_7874> registries;
        private class_7225.class_7874 registryAccess;

        public Simple(class_176 paramSet, DataProviderContext context) {
            this(paramSet, context.getPackOutput(), context.getRegistries());
        }

        public Simple(class_176 paramSet, class_7784 packOutput, CompletableFuture<class_7225.class_7874> registries) {
            this.paramSet = paramSet;
            this.pathProvider = packOutput.method_60917(class_7924.field_50079);
            this.registries = registries;
            this.registryAccess = class_5455.field_40585;
        }

        public CompletableFuture<?> method_10319(class_7403 output) {
            return this.registries.thenCompose(registries -> {
                this.registryAccess = registries;
                return this.run(output, (class_7225.class_7874)registries).thenRun(() -> {
                    this.registryAccess = class_5455.field_40585;
                });
            });
        }

        public String method_10321() {
            return String.join((CharSequence)" ", StringUtils.splitByCharacterTypeCamelCase((String)this.getClass().getSimpleName()));
        }

        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> exporter) {
            this.addLootTables();
            this.values.forEach(exporter);
        }

        @Override
        public class_7225.class_7874 registries() {
            Preconditions.checkState((this.registryAccess != class_5455.field_40585 ? 1 : 0) != 0, (Object)"registry access is empty");
            return this.registryAccess;
        }

        @Override
        public class_7784.class_7489 pathProvider() {
            return this.pathProvider;
        }

        @Override
        public class_176 paramSet() {
            return this.paramSet;
        }

        @Override
        public boolean skipValidationFor(class_5321<class_52> resourceKey) {
            return this.skipValidation.contains(resourceKey);
        }

        public void skipValidation(class_2960 resourceLocation) {
            this.skipValidation((class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)resourceLocation));
        }

        public void skipValidation(class_5321<class_52> resourceKey) {
            this.skipValidation.add(resourceKey);
        }

        protected void add(class_5321<class_52> table, class_52.class_53 builder) {
            this.values.put(table, builder);
        }

        public abstract void addLootTables();
    }

    public static abstract class EntityTypes
    extends class_7789
    implements LootTableDataProvider {
        private final Set<class_5321<class_52>> skipValidation = new HashSet<class_5321<class_52>>();
        private final class_7784.class_7489 pathProvider;
        private final CompletableFuture<class_7225.class_7874> registries;
        private final String modId;

        public EntityTypes(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput(), context.getRegistries());
        }

        public EntityTypes(String modId, class_7784 packOutput, CompletableFuture<class_7225.class_7874> registries) {
            super(class_7701.field_40180.method_45383(), (class_7225.class_7874)class_5455.field_40585);
            this.pathProvider = packOutput.method_60917(class_7924.field_50079);
            this.registries = registries;
            this.modId = modId;
        }

        public CompletableFuture<?> method_10319(class_7403 output) {
            return this.registries.thenCompose(registries -> {
                this.field_51846 = registries;
                return this.run(output, (class_7225.class_7874)registries).thenRun(() -> {
                    this.field_51846 = class_5455.field_40585;
                });
            });
        }

        public String method_10321() {
            return "Entity Type Loot Tables";
        }

        public final void method_10400() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> consumer) {
            this.method_10400();
            HashSet lootTables = new HashSet();
            this.getRegistryEntries().forEach(holder -> {
                class_1299 entityType = (class_1299)holder.comp_349();
                Map map = (Map)this.field_40615.remove(entityType);
                if (this.canHaveLootTable(entityType)) {
                    class_5321 resourceKey;
                    Optional optional = entityType.method_16351();
                    if (!(!optional.isPresent() || this.skipValidationFor((class_5321<class_52>)(resourceKey = (class_5321)optional.get())) || map != null && map.containsKey(resourceKey))) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loot table '%s' for '%s'", resourceKey, holder.method_40237().method_29177()));
                    }
                    if (map != null) {
                        map.forEach((resourceLocation, builder) -> {
                            if (!lootTables.add(resourceLocation)) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loot table '%s' for '%s'", resourceLocation, holder.method_40237().method_29177()));
                            }
                            consumer.accept((class_5321<class_52>)resourceLocation, (class_52.class_53)builder);
                        });
                    }
                } else if (map != null) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "Weird loot table(s) '%s' for '%s', not a LivingEntity so should not have loot", map.keySet().stream().map(class_5321::method_29177).map(class_2960::toString).collect(Collectors.joining(",")), holder.method_40237().method_29177()));
                }
            });
            if (!this.field_40615.isEmpty()) {
                throw new IllegalStateException("Created loot tables for entities not supported by data pack: " + String.valueOf(this.field_40615.keySet()));
            }
        }

        @Override
        public class_7225.class_7874 registries() {
            Preconditions.checkState((this.field_51846 != class_5455.field_40585 ? 1 : 0) != 0, (Object)"registry access is empty");
            return this.field_51846;
        }

        @Override
        public class_7784.class_7489 pathProvider() {
            return this.pathProvider;
        }

        @Override
        public class_176 paramSet() {
            return class_173.field_1173;
        }

        @Override
        public boolean skipValidationFor(class_5321<class_52> resourceKey) {
            return this.skipValidation.contains(resourceKey);
        }

        public void skipValidation(class_2960 resourceLocation) {
            this.skipValidation((class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)resourceLocation));
        }

        public void skipValidation(class_5321<class_52> resourceKey) {
            this.skipValidation.add(resourceKey);
        }

        public void skipValidation(class_1299<?> entityType) {
            entityType.method_16351().ifPresent(this::skipValidation);
        }

        protected boolean canHaveLootTable(class_1299<?> entityType) {
            return entityType.method_5891() != class_1311.field_17715;
        }

        protected Stream<class_6880.class_6883<class_1299<?>>> getRegistryEntries() {
            return class_7923.field_41177.method_42017().filter(holder -> holder.method_40237().method_29177().method_12836().equals(this.modId));
        }
    }

    public static abstract class Blocks
    extends class_7788
    implements LootTableDataProvider {
        private final Set<class_5321<class_52>> skipValidation = new HashSet<class_5321<class_52>>();
        private final class_7784.class_7489 pathProvider;
        private final CompletableFuture<class_7225.class_7874> registries;
        private final String modId;

        public Blocks(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput(), context.getRegistries());
        }

        public Blocks(String modId, class_7784 packOutput, CompletableFuture<class_7225.class_7874> registries) {
            super(Collections.emptySet(), class_7701.field_40180.method_45383(), (class_7225.class_7874)class_5455.field_40585);
            this.pathProvider = packOutput.method_60917(class_7924.field_50079);
            this.registries = registries;
            this.modId = modId;
        }

        public CompletableFuture<?> method_10319(class_7403 output) {
            return ((CompletableFuture)((CompletableFuture)this.registries.thenApply(registries -> {
                this.field_51845 = registries;
                return this.field_51845;
            })).thenCompose(registries -> this.run(output, (class_7225.class_7874)registries))).thenRun(() -> {
                this.field_51845 = class_5455.field_40585;
            });
        }

        public String method_10321() {
            return "Block Loot Tables";
        }

        public final void method_10379() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> consumer) {
            this.method_10379();
            HashSet lootTables = new HashSet();
            this.getRegistryEntries().forEach(holder -> {
                class_5321 resourceKey;
                Optional optional = ((class_2248)holder.comp_349()).method_26162();
                if (optional.isPresent() && lootTables.add(resourceKey = (class_5321)optional.get())) {
                    class_52.class_53 builder = (class_52.class_53)this.field_40610.remove(resourceKey);
                    if (builder != null) {
                        consumer.accept(resourceKey, builder);
                    } else if (!this.skipValidationFor((class_5321<class_52>)resourceKey)) {
                        throw new IllegalStateException("Missing loot table '%s' for '%s'".formatted(optional, holder.method_40237().method_29177()));
                    }
                }
            });
            if (!this.field_40610.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + String.valueOf(this.field_40610.keySet()));
            }
        }

        @Override
        public class_7225.class_7874 registries() {
            Preconditions.checkState((this.field_51845 != class_5455.field_40585 ? 1 : 0) != 0, (Object)"registry access is empty");
            return this.field_51845;
        }

        @Override
        public class_7784.class_7489 pathProvider() {
            return this.pathProvider;
        }

        @Override
        public class_176 paramSet() {
            return class_173.field_1172;
        }

        @Override
        public boolean skipValidationFor(class_5321<class_52> resourceKey) {
            return this.skipValidation.contains(resourceKey);
        }

        public void skipValidation(class_2960 resourceLocation) {
            this.skipValidation((class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)resourceLocation));
        }

        public void skipValidation(class_5321<class_52> resourceKey) {
            this.skipValidation.add(resourceKey);
        }

        public void skipValidation(class_2248 block) {
            block.method_26162().ifPresent(this::skipValidation);
        }

        public void dropNothing(class_2248 block) {
            this.method_45988(block, Blocks.method_45975());
        }

        public void dropNameable(class_2248 block) {
            this.method_45994(block, arg_0 -> ((Blocks)this).method_45996(arg_0));
        }

        protected Stream<class_6880.class_6883<class_2248>> getRegistryEntries() {
            return class_7923.field_41175.method_42017().filter(holder -> holder.method_40237().method_29177().method_12836().equals(this.modId));
        }
    }
}

