/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.api.client.gui.v2;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.ToIntFunction;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.fabricmc.fabric.impl.client.rendering.hud.HudElementRegistryImpl;
import net.fabricmc.fabric.impl.client.rendering.hud.HudLayer;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public final class HudStatusBarHeightRegistryImpl {
    static final int DEFAULT_HEIGHT = 39;
    static final int HELD_ITEM_TOOLTIP_HEIGHT = 20;
    static final int OVERLAY_MESSAGE_HEIGHT = 29;
    static final int TEXT_HEIGHT_DELTA = 9;
    static final ToIntFunction<class_1657> ZERO = player -> 0;
    static final ToIntFunction<class_1657> HEALTH_BAR = player -> {
        class_329 gui = class_310.method_1551().field_1705;
        int playerHealth = class_3532.method_15386((float)player.method_6032());
        int displayHealth = gui.field_2033;
        float maxHealth = Math.max((float)player.method_45325(class_5134.field_23716), (float)Math.max(displayHealth, playerHealth));
        int absorptionAmount = class_3532.method_15386((float)player.method_6067());
        int healthRows = class_3532.method_15386((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
        int rowShift = Math.max(10 - (healthRows - 2), 3);
        return 10 + (healthRows - 1) * rowShift;
    };
    static final ToIntFunction<class_1657> ARMOR_BAR = player -> player.method_6096() > 0 ? 10 : 0;
    static final ToIntFunction<class_1657> MOUNT_HEALTH = player -> {
        class_329 gui = class_310.method_1551().field_1705;
        class_1309 livingEntity = gui.method_1734();
        int vehicleMaxHearts = gui.method_1744(livingEntity);
        return gui.method_1733(vehicleMaxHearts) * 10;
    };
    static final ToIntFunction<class_1657> FOOD_BAR = player -> {
        class_329 gui = class_310.method_1551().field_1705;
        class_1309 livingEntity = gui.method_1734();
        return gui.method_1744(livingEntity) == 0 ? 10 : 0;
    };
    static final ToIntFunction<class_1657> AIR_BAR = player -> {
        int maxAirSupply = player.method_5748();
        int airSupply = Math.clamp((long)player.method_5669(), 0, maxAirSupply);
        boolean isInWater = player.method_5777(class_3486.field_15517);
        return isInWater || airSupply < maxAirSupply ? 10 : 0;
    };
    static final Map<class_2960, ToIntFunction<class_1657>> VANILLA_HEIGHT_PROVIDERS = ImmutableMap.of((Object)VanillaHudElements.HEALTH_BAR, ZERO, (Object)VanillaHudElements.ARMOR_BAR, HEALTH_BAR, (Object)VanillaHudElements.MOUNT_HEALTH, ZERO, (Object)VanillaHudElements.FOOD_BAR, ZERO, (Object)VanillaHudElements.AIR_BAR, HudStatusBarHeightRegistryImpl.reduceToIntFunctions(MOUNT_HEALTH, FOOD_BAR, Integer::sum));
    static final Map<class_2960, ToIntFunction<class_1657>> VANILLA_LEFT_HEIGHT_PROVIDERS = ImmutableMap.of((Object)VanillaHudElements.HEALTH_BAR, HEALTH_BAR, (Object)VanillaHudElements.ARMOR_BAR, ARMOR_BAR);
    static final Map<class_2960, ToIntFunction<class_1657>> VANILLA_RIGHT_HEIGHT_PROVIDERS = ImmutableMap.of((Object)VanillaHudElements.MOUNT_HEALTH, MOUNT_HEALTH, (Object)VanillaHudElements.FOOD_BAR, FOOD_BAR, (Object)VanillaHudElements.AIR_BAR, AIR_BAR);
    static final Map<class_2960, ToIntFunction<class_1657>> LEFT_HEIGHT_PROVIDERS = new HashMap<class_2960, ToIntFunction<class_1657>>(VANILLA_LEFT_HEIGHT_PROVIDERS);
    static final Map<class_2960, ToIntFunction<class_1657>> RIGHT_HEIGHT_PROVIDERS = new HashMap<class_2960, ToIntFunction<class_1657>>(VANILLA_RIGHT_HEIGHT_PROVIDERS);
    @Nullable
    static Map<class_2960, ToIntFunction<class_1657>> resolvedHeightProviders;

    private HudStatusBarHeightRegistryImpl() {
    }

    public static void addLeft(class_2960 id, ToIntFunction<class_1657> heightProvider) {
        if (resolvedHeightProviders != null) {
            throw new IllegalStateException("Height provider registry already frozen!");
        }
        LEFT_HEIGHT_PROVIDERS.put(id, heightProvider);
    }

    public static void addRight(class_2960 id, ToIntFunction<class_1657> heightProvider) {
        if (resolvedHeightProviders != null) {
            throw new IllegalStateException("Height provider registry already frozen!");
        }
        RIGHT_HEIGHT_PROVIDERS.put(id, heightProvider);
    }

    public static int getHeight(class_2960 id) {
        if (resolvedHeightProviders == null) {
            throw new IllegalStateException("Trying to get status bar height for " + String.valueOf(id) + " too early");
        }
        if (!resolvedHeightProviders.containsKey(id)) {
            throw new IllegalArgumentException("Unknown status bar: " + String.valueOf(id));
        }
        class_1657 player = class_310.method_1551().field_1705.method_1737();
        if (player == null) {
            throw new IllegalStateException("Trying to get status bar height for " + String.valueOf(id) + " without a camera player");
        }
        return 39 + resolvedHeightProviders.get(id).applyAsInt(player);
    }

    public static void init() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ToIntFunction<class_1657> maxLeftHeightProvider = HudStatusBarHeightRegistryImpl.resolveHeightProviders(LEFT_HEIGHT_PROVIDERS, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ToIntFunction<class_1657> maxRightHeightProvider = HudStatusBarHeightRegistryImpl.resolveHeightProviders(RIGHT_HEIGHT_PROVIDERS, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        resolvedHeightProviders = builder.build();
        HudStatusBarHeightRegistryImpl.applyVanillaHeightProviders(resolvedHeightProviders, HudStatusBarHeightRegistryImpl.reduceToIntFunctions(maxLeftHeightProvider, maxRightHeightProvider, Math::max));
    }

    private static List<class_2960> getOrderedHeightProviders(Map<class_2960, ToIntFunction<class_1657>> heightProviderLookup) {
        ArrayList<class_2960> orderedHeightProviders = new ArrayList<class_2960>();
        for (class_2960 class_29602 : VANILLA_HEIGHT_PROVIDERS.keySet()) {
            for (HudLayer hudLayer : ((HudElementRegistryImpl.RootLayer)HudElementRegistryImpl.ROOT_ELEMENTS.get(class_29602)).layers()) {
                if (hudLayer.isRemoved() || !heightProviderLookup.containsKey(hudLayer.id())) continue;
                orderedHeightProviders.add(hudLayer.id());
            }
        }
        for (Map.Entry entry : HudElementRegistryImpl.ROOT_ELEMENTS.entrySet()) {
            if (VANILLA_HEIGHT_PROVIDERS.containsKey(entry.getKey())) continue;
            for (HudLayer hudLayer : ((HudElementRegistryImpl.RootLayer)entry.getValue()).layers()) {
                if (hudLayer.isRemoved() || !heightProviderLookup.containsKey(hudLayer.id())) continue;
                orderedHeightProviders.add(hudLayer.id());
            }
        }
        return orderedHeightProviders;
    }

    private static ToIntFunction<class_1657> resolveHeightProviders(Map<class_2960, ToIntFunction<class_1657>> heightProviderLookup, BiConsumer<class_2960, ToIntFunction<class_1657>> heightProviderConsumer) {
        List<class_2960> orderedHeightProviders = HudStatusBarHeightRegistryImpl.getOrderedHeightProviders(heightProviderLookup);
        for (class_2960 resourceLocation : heightProviderLookup.keySet()) {
            ToIntFunction<class_1657> heightProvider = HudStatusBarHeightRegistryImpl.resolveHeightProvider(resourceLocation, heightProviderLookup, orderedHeightProviders);
            heightProviderConsumer.accept(resourceLocation, heightProvider);
        }
        return HudStatusBarHeightRegistryImpl.resolveMaximumHeightProvider(orderedHeightProviders.getLast(), heightProviderLookup, orderedHeightProviders);
    }

    private static ToIntFunction<class_1657> resolveHeightProvider(class_2960 resourceLocation, Map<class_2960, ToIntFunction<class_1657>> heightProviderLookup, List<class_2960> orderedHeightProviders) {
        ToIntFunction<class_1657> heightProvider = ZERO;
        for (class_2960 heightProviderLocation : orderedHeightProviders) {
            if (heightProviderLocation.equals((Object)resourceLocation)) {
                return heightProvider;
            }
            if (!heightProviderLookup.containsKey(heightProviderLocation)) continue;
            heightProvider = HudStatusBarHeightRegistryImpl.reduceToIntFunctions(heightProvider, heightProviderLookup.get(heightProviderLocation), Integer::sum);
        }
        throw new IllegalStateException();
    }

    private static ToIntFunction<class_1657> resolveMaximumHeightProvider(class_2960 resourceLocation, Map<class_2960, ToIntFunction<class_1657>> heightProviderLookup, List<class_2960> orderedHeightProviders) {
        ToIntFunction<class_1657> heightProvider = HudStatusBarHeightRegistryImpl.resolveHeightProvider(resourceLocation, heightProviderLookup, orderedHeightProviders);
        return HudStatusBarHeightRegistryImpl.reduceToIntFunctions(heightProviderLookup.get(resourceLocation), heightProvider, Integer::sum);
    }

    private static <T> ToIntFunction<T> reduceToIntFunctions(ToIntFunction<T> first, ToIntFunction<T> second, IntBinaryOperator operator) {
        return t -> operator.applyAsInt(first.applyAsInt(t), second.applyAsInt(t));
    }

    private static void applyVanillaHeightProviders(Map<class_2960, ToIntFunction<class_1657>> resolvedHeightProviders, ToIntFunction<class_1657> maxHeightProvider) {
        for (Map.Entry<class_2960, ToIntFunction<class_1657>> entry : VANILLA_HEIGHT_PROVIDERS.entrySet()) {
            if (!HudStatusBarHeightRegistryImpl.isVanillaHeightProvider(entry.getKey())) continue;
            ToIntFunction<class_1657> actualHeightProvider = resolvedHeightProviders.get(entry.getKey());
            ToIntFunction<class_1657> expectedHeightProvider = entry.getValue();
            HudStatusBarHeightRegistryImpl.replaceVanillaElement(entry.getKey(), HudStatusBarHeightRegistryImpl.reduceToIntFunctions(expectedHeightProvider, actualHeightProvider, (i1, i2) -> i1 - i2));
        }
        HudStatusBarHeightRegistryImpl.replaceVanillaElement(VanillaHudElements.HELD_ITEM_TOOLTIP, player -> 20 - Math.max(20, maxHeightProvider.applyAsInt((class_1657)player)));
        HudStatusBarHeightRegistryImpl.replaceVanillaElement(VanillaHudElements.OVERLAY_MESSAGE, player -> 29 - Math.max(29, maxHeightProvider.applyAsInt((class_1657)player) + 9));
    }

    private static boolean isVanillaHeightProvider(class_2960 resourceLocation) {
        if (LEFT_HEIGHT_PROVIDERS.containsKey(resourceLocation) && LEFT_HEIGHT_PROVIDERS.get(resourceLocation) == VANILLA_LEFT_HEIGHT_PROVIDERS.get(resourceLocation)) {
            return true;
        }
        return RIGHT_HEIGHT_PROVIDERS.containsKey(resourceLocation) && RIGHT_HEIGHT_PROVIDERS.get(resourceLocation) == VANILLA_RIGHT_HEIGHT_PROVIDERS.get(resourceLocation);
    }

    private static void replaceVanillaElement(class_2960 resourceLocation, ToIntFunction<class_1657> heightProvider) {
        HudElementRegistry.replaceElement((class_2960)resourceLocation, layer -> (guiGraphics, deltaTracker) -> {
            int height;
            class_1657 player = class_310.method_1551().field_1705.method_1737();
            int n = height = player != null ? heightProvider.applyAsInt(player) : 0;
            if (height != 0) {
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate(0.0f, (float)height);
            }
            layer.render(guiGraphics, deltaTracker);
            if (height != 0) {
                guiGraphics.method_51448().popMatrix();
            }
        });
    }
}

