/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts;

import com.google.common.collect.ImmutableMap;
import fuzs.forgeconfigapiport.fabric.api.v5.ConfigRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.jmb19905.niftycarts.NiftyCartsConfig;
import net.jmb19905.niftycarts.advancement.NCCriteriaTriggers;
import net.jmb19905.niftycarts.container.PlowMenu;
import net.jmb19905.niftycarts.container.SeedDrillMenu;
import net.jmb19905.niftycarts.entity.AnimalCartEntity;
import net.jmb19905.niftycarts.entity.HandCartEntity;
import net.jmb19905.niftycarts.entity.PlowEntity;
import net.jmb19905.niftycarts.entity.PostilionEntity;
import net.jmb19905.niftycarts.entity.ReaperCartEntity;
import net.jmb19905.niftycarts.entity.SeedDrillEntity;
import net.jmb19905.niftycarts.entity.SupplyCartEntity;
import net.jmb19905.niftycarts.entity.WagonEntity;
import net.jmb19905.niftycarts.entity.ai.goal.AvoidCartGoal;
import net.jmb19905.niftycarts.entity.ai.goal.PullCartGoal;
import net.jmb19905.niftycarts.entity.ai.goal.RideCartGoal;
import net.jmb19905.niftycarts.item.CartItem;
import net.jmb19905.niftycarts.network.clientbound.UpdateDrawnPayload;
import net.jmb19905.niftycarts.network.serverbound.ActionKeyPayload;
import net.jmb19905.niftycarts.network.serverbound.CoachmanMovePayload;
import net.jmb19905.niftycarts.network.serverbound.OpenSupplyCartPayload;
import net.jmb19905.niftycarts.network.serverbound.RequestCartUpdatePayload;
import net.jmb19905.niftycarts.network.serverbound.ToggleSlowPayload;
import net.jmb19905.niftycarts.util.NiftyGoalAdder;
import net.jmb19905.niftycarts.util.NiftyWorld;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_3917;
import net.minecraft.class_4719;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7696;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.apache.commons.lang3.function.TriFunction;

public class NiftyCarts
implements ModInitializer {
    public static final String MOD_ID = "niftycarts";
    public static final class_1792 WHEEL = NiftyCarts.register("wheel", class_1792::new);
    private static final TriFunction<class_4719, String, class_7696[], CartItem> CART_ITEM_SUPPLIER = (wood, type, flags) -> NiftyCarts.register(wood.comp_1299() + "_" + type, (class_1792.class_1793 prop) -> new CartItem((class_4719)wood, (String)type, prop.method_7889(1).method_45434(flags)));
    public static final Map<class_4719, CartItem> SUPPLY_CART = new HashMap<class_4719, CartItem>();
    public static final Map<class_4719, CartItem> HAND_CART = new HashMap<class_4719, CartItem>();
    public static final Map<class_4719, CartItem> PLOW = new HashMap<class_4719, CartItem>();
    public static final Map<class_4719, CartItem> ANIMAL_CART = new HashMap<class_4719, CartItem>();
    public static final Map<class_4719, CartItem> SEED_DRILL = new HashMap<class_4719, CartItem>();
    public static final Map<class_4719, CartItem> REAPER = new HashMap<class_4719, CartItem>();
    public static final Map<class_4719, CartItem> WAGON = new HashMap<class_4719, CartItem>();
    public static final class_4719[] VANILLA_WOOD_TYPES;
    public static MinecraftServer server;
    public static final class_2960 ATTACH_SOUND_ID;
    public static final class_2960 DETACH_SOUND_ID;
    public static final class_2960 PLACE_SOUND_ID;
    public static class_3414 ATTACH_SOUND;
    public static class_3414 DETACH_SOUND;
    public static class_3414 PLACE_SOUND;
    public static final class_1299<SupplyCartEntity> SUPPLY_CART_ENTITY;
    public static final class_1299<AnimalCartEntity> ANIMAL_CART_ENTITY;
    public static final class_1299<PlowEntity> PLOW_ENTITY;
    public static final class_1299<HandCartEntity> HAND_CART_ENTITY;
    public static final class_1299<SeedDrillEntity> SEED_DRILL_ENTITY;
    public static final class_1299<ReaperCartEntity> REAPER_ENTITY;
    public static final class_1299<WagonEntity> WAGON_ENTITY;
    public static final class_1299<PostilionEntity> POSTILION_ENTITY;
    public static final NiftyGoalAdder<class_1308> MOB_GOAL_ADDER;
    public static final NiftyGoalAdder<class_1314> PATHFINDER_GOAL_ADDER;
    public static final class_3917<PlowMenu> PLOW_MENU_TYPE;
    public static final class_3917<SeedDrillMenu> SEED_DRILL_MENU_TYPE;
    public static final class_3917<class_1707> CHEST_9x4_MENU_TYPE;
    public static final class_3917<class_1707> CHEST_9x8_MENU_TYPE;
    public static final class_3917<class_1707> CHEST_9x12_MENU_TYPE;
    public static final Map<class_1299<?>, class_2960> CART_PULL_CM;
    public static final class_2960 RIDE_CART_CM;
    public static final class_2960 STEER_ANIMAL_CART_CM;
    public static final class_2960 STEER_REAPER_CM;
    public static final class_6862<class_2248> PLOW_BREAKABLE_HOE;
    public static final class_6862<class_2248> PLOW_BREAKABLE_SHOVEL;
    public static final class_6862<class_2248> PLOW_BREAKABLE_AXE;
    public static final class_6862<class_2248> REAPER_HARVESTABLE;
    public static final class_6862<class_1792> SEED_DRILL_PLANTABLE;

    private static void registerStat(class_2960 id, class_3446 formatter) {
        class_2378.method_10230((class_2378)class_7923.field_41183, (class_2960)id, (Object)id);
        class_3468.field_15419.method_14955((Object)id, formatter);
    }

    public void onInitialize() {
        ConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.COMMON, (IConfigSpec)NiftyCartsConfig.spec());
        for (class_2960 stat : CART_PULL_CM.values()) {
            NiftyCarts.registerStat(stat, class_3446.field_16977);
        }
        NiftyCarts.registerStat(RIDE_CART_CM, class_3446.field_16977);
        NiftyCarts.registerStat(STEER_ANIMAL_CART_CM, class_3446.field_16977);
        NiftyCarts.registerStat(STEER_REAPER_CM, class_3446.field_16977);
        NCCriteriaTriggers.register();
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)NiftyCarts.resLoc("plow"), PLOW_MENU_TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)NiftyCarts.resLoc("seed_drill"), SEED_DRILL_MENU_TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)NiftyCarts.resLoc("chest_four_rows"), CHEST_9x4_MENU_TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)NiftyCarts.resLoc("chest_eight_rows"), CHEST_9x8_MENU_TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)NiftyCarts.resLoc("chest_quad"), CHEST_9x12_MENU_TYPE);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41062).register(content -> content.method_45421((class_1935)WHEEL));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(content -> Arrays.stream(VANILLA_WOOD_TYPES).forEach(woodType -> {
            content.method_45421((class_1935)SUPPLY_CART.get(woodType));
            content.method_45421((class_1935)PLOW.get(woodType));
            content.method_45421((class_1935)SEED_DRILL.get(woodType));
            content.method_45421((class_1935)REAPER.get(woodType));
            content.method_45421((class_1935)ANIMAL_CART.get(woodType));
            content.method_45421((class_1935)HAND_CART.get(woodType));
            content.method_45421((class_1935)WAGON.get(woodType));
        }));
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ATTACH_SOUND_ID, (Object)ATTACH_SOUND);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)DETACH_SOUND_ID, (Object)DETACH_SOUND);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)PLACE_SOUND_ID, (Object)PLACE_SOUND);
        PayloadTypeRegistry.playC2S().register(ActionKeyPayload.TYPE, ActionKeyPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(OpenSupplyCartPayload.TYPE, OpenSupplyCartPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ToggleSlowPayload.TYPE, ToggleSlowPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestCartUpdatePayload.TYPE, RequestCartUpdatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CoachmanMovePayload.TYPE, CoachmanMovePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(UpdateDrawnPayload.TYPE, UpdateDrawnPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ActionKeyPayload.TYPE, (payload, context) -> ActionKeyPayload.handle(context.player()));
        ServerPlayNetworking.registerGlobalReceiver(OpenSupplyCartPayload.TYPE, (payload, context) -> OpenSupplyCartPayload.handle((class_1657)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(ToggleSlowPayload.TYPE, (payload, context) -> ToggleSlowPayload.handle((class_1657)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(RequestCartUpdatePayload.TYPE, (payload, context) -> RequestCartUpdatePayload.handle(payload, context.player()));
        ServerPlayNetworking.registerGlobalReceiver(CoachmanMovePayload.TYPE, (payload, context) -> CoachmanMovePayload.handle(payload, context.player()));
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            server = s;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(s -> {
            server = null;
        });
        ServerTickEvents.END_SERVER_TICK.register(e -> {
            for (class_5321 levelKey : e.method_29435()) {
                NiftyWorld.getServer(server, (class_5321<class_1937>)levelKey).tick((class_1937)server.method_3847(levelKey));
            }
        });
        UseEntityCallback.EVENT.register((player, level, hand, entity, hitResult) -> {
            class_1309 rider = entity.method_5642();
            if (rider instanceof PostilionEntity) {
                rider.method_5848();
            }
            return class_1269.field_5811;
        });
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            MOB_GOAL_ADDER.onEntityJoinWorld(entity);
            PATHFINDER_GOAL_ADDER.onEntityJoinWorld(entity);
        });
        FabricDefaultAttributeRegistry.register(POSTILION_ENTITY, (class_5132.class_5133)class_1309.method_26827());
    }

    public static <T extends class_1297> class_1299<T> register(String id, class_1299.class_1300<T> builder) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)NiftyCarts.resLoc(id));
        return (class_1299)class_2378.method_39197((class_2378)class_7923.field_41177, (class_5321)key, (Object)builder.method_5905(key));
    }

    public static <I extends class_1792> I register(String id, Function<class_1792.class_1793, I> function) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)NiftyCarts.resLoc(id));
        class_1792 item = (class_1792)function.apply(new class_1792.class_1793().method_63686(key));
        return (I)((class_1792)class_2378.method_39197((class_2378)class_7923.field_41178, (class_5321)key, (Object)item));
    }

    public static class_2960 resLoc(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    static {
        for (class_4719 woodType : VANILLA_WOOD_TYPES = new class_4719[]{class_4719.field_21676, class_4719.field_21677, class_4719.field_21678, class_4719.field_21679, class_4719.field_42837, class_4719.field_21680, class_4719.field_21681, class_4719.field_54795, class_4719.field_22183, class_4719.field_22184, class_4719.field_37657, class_4719.field_40350}) {
            class_7696[] flags2 = new class_7696[]{};
            SUPPLY_CART.put(woodType, (CartItem)((Object)CART_ITEM_SUPPLIER.apply((Object)woodType, (Object)"supply_cart", (Object)flags2)));
            HAND_CART.put(woodType, (CartItem)((Object)CART_ITEM_SUPPLIER.apply((Object)woodType, (Object)"hand_cart", (Object)flags2)));
            PLOW.put(woodType, (CartItem)((Object)CART_ITEM_SUPPLIER.apply((Object)woodType, (Object)"plow", (Object)flags2)));
            SEED_DRILL.put(woodType, (CartItem)((Object)CART_ITEM_SUPPLIER.apply((Object)woodType, (Object)"seed_drill", (Object)flags2)));
            REAPER.put(woodType, (CartItem)((Object)CART_ITEM_SUPPLIER.apply((Object)woodType, (Object)"reaper", (Object)flags2)));
            ANIMAL_CART.put(woodType, (CartItem)((Object)CART_ITEM_SUPPLIER.apply((Object)woodType, (Object)"animal_cart", (Object)flags2)));
            WAGON.put(woodType, (CartItem)((Object)CART_ITEM_SUPPLIER.apply((Object)woodType, (Object)"wagon", (Object)flags2)));
        }
        server = null;
        ATTACH_SOUND_ID = NiftyCarts.resLoc("entity.cart.attach");
        DETACH_SOUND_ID = NiftyCarts.resLoc("entity.cart.detach");
        PLACE_SOUND_ID = NiftyCarts.resLoc("entity.cart.place");
        ATTACH_SOUND = class_3414.method_47908((class_2960)ATTACH_SOUND_ID);
        DETACH_SOUND = class_3414.method_47908((class_2960)DETACH_SOUND_ID);
        PLACE_SOUND = class_3414.method_47908((class_2960)PLACE_SOUND_ID);
        SUPPLY_CART_ENTITY = NiftyCarts.register("supply_cart", class_1299.class_1300.method_5903(SupplyCartEntity::new, (class_1311)class_1311.field_17715).method_17687(1.5f, 1.4f));
        ANIMAL_CART_ENTITY = NiftyCarts.register("animal_cart", class_1299.class_1300.method_5903(AnimalCartEntity::new, (class_1311)class_1311.field_17715).method_17687(1.3f, 1.4f));
        PLOW_ENTITY = NiftyCarts.register("plow", class_1299.class_1300.method_5903(PlowEntity::new, (class_1311)class_1311.field_17715).method_17687(1.3f, 1.4f));
        HAND_CART_ENTITY = NiftyCarts.register("hand_cart", class_1299.class_1300.method_5903(HandCartEntity::new, (class_1311)class_1311.field_17715).method_17687(1.3f, 1.1f));
        SEED_DRILL_ENTITY = NiftyCarts.register("seed_drill", class_1299.class_1300.method_5903(SeedDrillEntity::new, (class_1311)class_1311.field_17715).method_17687(1.3f, 1.4f));
        REAPER_ENTITY = NiftyCarts.register("reaper", class_1299.class_1300.method_5903(ReaperCartEntity::new, (class_1311)class_1311.field_17715).method_17687(1.3f, 1.4f));
        WAGON_ENTITY = NiftyCarts.register("wagon", class_1299.class_1300.method_5903(WagonEntity::new, (class_1311)class_1311.field_17715).method_17687(2.5f, 3.0f));
        POSTILION_ENTITY = NiftyCarts.register("postilion", class_1299.class_1300.method_5903(PostilionEntity::new, (class_1311)class_1311.field_17715).method_17687(0.25f, 0.25f).method_5901().method_5904());
        MOB_GOAL_ADDER = NiftyGoalAdder.mobGoal(class_1308.class).add(1, PullCartGoal::new).add(1, RideCartGoal::new).build();
        PATHFINDER_GOAL_ADDER = NiftyGoalAdder.mobGoal(class_1314.class).add(3, mob -> new AvoidCartGoal<SupplyCartEntity>((class_1314)mob, SupplyCartEntity.class, 3.0f, 0.5)).add(3, mob -> new AvoidCartGoal<PlowEntity>((class_1314)mob, PlowEntity.class, 3.0f, 0.5)).add(3, mob -> new AvoidCartGoal<SeedDrillEntity>((class_1314)mob, SeedDrillEntity.class, 3.0f, 0.5)).add(3, mob -> new AvoidCartGoal<ReaperCartEntity>((class_1314)mob, ReaperCartEntity.class, 3.0f, 0.5)).build();
        PLOW_MENU_TYPE = new class_3917(PlowMenu::new, class_7701.field_40183);
        SEED_DRILL_MENU_TYPE = new class_3917(SeedDrillMenu::new, class_7701.field_40183);
        CHEST_9x4_MENU_TYPE = new class_3917((i, inv) -> new class_1707(CHEST_9x4_MENU_TYPE, i, inv, (class_1263)new class_1277(36), 4), class_7701.field_40183);
        CHEST_9x8_MENU_TYPE = new class_3917((i, inv) -> new class_1707(CHEST_9x8_MENU_TYPE, i, inv, (class_1263)new class_1277(72), 8), class_7701.field_40183);
        CHEST_9x12_MENU_TYPE = new class_3917((i, inv) -> new class_1707(CHEST_9x12_MENU_TYPE, i, inv, (class_1263)new class_1277(108), 12), class_7701.field_40183);
        CART_PULL_CM = ImmutableMap.of(SUPPLY_CART_ENTITY, (Object)class_2960.method_60655((String)MOD_ID, (String)"supply_cart_pull_cm"), HAND_CART_ENTITY, (Object)class_2960.method_60655((String)MOD_ID, (String)"hand_cart_pull_cm"), ANIMAL_CART_ENTITY, (Object)class_2960.method_60655((String)MOD_ID, (String)"animal_cart_pull_cm"), PLOW_ENTITY, (Object)class_2960.method_60655((String)MOD_ID, (String)"plow_pull_cm"), REAPER_ENTITY, (Object)class_2960.method_60655((String)MOD_ID, (String)"reaper_pull_cm"), SEED_DRILL_ENTITY, (Object)class_2960.method_60655((String)MOD_ID, (String)"seed_drill_pull_cm"), WAGON_ENTITY, (Object)class_2960.method_60655((String)MOD_ID, (String)"wagon_pull_cm"));
        RIDE_CART_CM = class_2960.method_60655((String)MOD_ID, (String)"ride_cart_cm");
        STEER_ANIMAL_CART_CM = class_2960.method_60655((String)MOD_ID, (String)"steer_animal_cart_cm");
        STEER_REAPER_CM = class_2960.method_60655((String)MOD_ID, (String)"steer_reaper_cm");
        PLOW_BREAKABLE_HOE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)NiftyCarts.resLoc("plow_breakable/hoe"));
        PLOW_BREAKABLE_SHOVEL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)NiftyCarts.resLoc("plow_breakable/shovel"));
        PLOW_BREAKABLE_AXE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)NiftyCarts.resLoc("plow_breakable/axe"));
        REAPER_HARVESTABLE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"reaper_harvestable"));
        SEED_DRILL_PLANTABLE = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)NiftyCarts.resLoc("seed_drill_plantable"));
    }
}

