/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client;

import com.google.common.collect.ImmutableMap;
import fuzs.forgeconfigapiport.fabric.api.v5.ConfigRegistry;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.jmb19905.niftycarts.NiftyCarts;
import net.jmb19905.niftycarts.NiftyCartsConfig;
import net.jmb19905.niftycarts.client.renderer.NiftyCartsModelLayers;
import net.jmb19905.niftycarts.client.renderer.entity.AnimalCartRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.HandCartRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.PlowRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.PostilionRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.ReaperRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.SeedDrillRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.SupplyCartRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.WagonRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.model.AnimalCartModel;
import net.jmb19905.niftycarts.client.renderer.entity.model.HandCartModel;
import net.jmb19905.niftycarts.client.renderer.entity.model.PlowModel;
import net.jmb19905.niftycarts.client.renderer.entity.model.ReaperModel;
import net.jmb19905.niftycarts.client.renderer.entity.model.SeedDrillModel;
import net.jmb19905.niftycarts.client.renderer.entity.model.SupplyCartModel;
import net.jmb19905.niftycarts.client.renderer.entity.model.WagonModel;
import net.jmb19905.niftycarts.client.screen.ChestScreen;
import net.jmb19905.niftycarts.client.screen.PlowScreen;
import net.jmb19905.niftycarts.client.screen.SeedDrillScreen;
import net.jmb19905.niftycarts.item.CartItem;
import net.jmb19905.niftycarts.network.clientbound.UpdateDrawnPayload;
import net.jmb19905.niftycarts.network.serverbound.ActionKeyPayload;
import net.jmb19905.niftycarts.network.serverbound.ToggleSlowPayload;
import net.jmb19905.niftycarts.util.NiftyWorld;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_4719;
import net.minecraft.class_5601;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraftforge.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;

@Environment(value=EnvType.CLIENT)
public class NiftyCartsClient
implements ClientModInitializer {
    public static final ImmutableMap<class_4719, String> LOG_NAME_OVERRIDE = ImmutableMap.of((Object)class_4719.field_22183, (Object)"stem", (Object)class_4719.field_22184, (Object)"stem", (Object)class_4719.field_40350, (Object)"block");
    private static class_304 actionKeyMapping;
    public static class_304 toggleSlowMapping;

    public void onInitializeClient() {
        ConfigRegistry.INSTANCE.register("niftycarts", ModConfig.Type.CLIENT, (IConfigSpec)NiftyCartsConfig.clientSpec());
        ClientPlayNetworking.registerGlobalReceiver(UpdateDrawnPayload.TYPE, (payload, ctx) -> ctx.client().execute(() -> UpdateDrawnPayload.handle(payload, (class_1937)Objects.requireNonNull(ctx.client().field_1687))));
        EntityRendererRegistry.register(NiftyCarts.SUPPLY_CART_ENTITY, SupplyCartRenderer::new);
        EntityRendererRegistry.register(NiftyCarts.ANIMAL_CART_ENTITY, AnimalCartRenderer::new);
        EntityRendererRegistry.register(NiftyCarts.PLOW_ENTITY, PlowRenderer::new);
        EntityRendererRegistry.register(NiftyCarts.HAND_CART_ENTITY, HandCartRenderer::new);
        EntityRendererRegistry.register(NiftyCarts.SEED_DRILL_ENTITY, SeedDrillRenderer::new);
        EntityRendererRegistry.register(NiftyCarts.REAPER_ENTITY, ReaperRenderer::new);
        EntityRendererRegistry.register(NiftyCarts.WAGON_ENTITY, WagonRenderer::new);
        EntityRendererRegistry.register(NiftyCarts.POSTILION_ENTITY, PostilionRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)NiftyCartsModelLayers.SUPPLY_CART, SupplyCartModel::createLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)NiftyCartsModelLayers.ANIMAL_CART, AnimalCartModel::createLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)NiftyCartsModelLayers.PLOW, PlowModel::createLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)NiftyCartsModelLayers.HAND_CART, HandCartModel::createLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)NiftyCartsModelLayers.SEED_DRILL, SeedDrillModel::createLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)NiftyCartsModelLayers.REAPER, ReaperModel::createLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)NiftyCartsModelLayers.WAGON, WagonModel::createLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)NiftyCartsModelLayers.WAGON_ROOF, WagonModel::createRoofLayer);
        EntityModelLayerRegistry.registerModelLayer((class_5601)NiftyCartsModelLayers.WAGON_CHEST, WagonModel::createChestLayer);
        class_3929.method_17542(NiftyCarts.PLOW_MENU_TYPE, PlowScreen::new);
        class_3929.method_17542(NiftyCarts.SEED_DRILL_MENU_TYPE, SeedDrillScreen::new);
        class_3929.method_17542(NiftyCarts.CHEST_9x4_MENU_TYPE, ChestScreen::new);
        class_3929.method_17542(NiftyCarts.CHEST_9x8_MENU_TYPE, ChestScreen::new);
        class_3929.method_17542(NiftyCarts.CHEST_9x12_MENU_TYPE, ChestScreen::new);
        actionKeyMapping = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.niftycarts.action", class_3675.class_307.field_1668, 82, "key.categories.niftycarts"));
        toggleSlowMapping = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.niftycarts.slow", class_3675.class_307.field_1668, 90, "key.categories.niftycarts"));
        ItemTooltipCallback.EVENT.register((stack, tooltipContext, tooltipType, lines) -> {
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof CartItem) {
                CartItem cart = (CartItem)patt0$temp;
                if (!class_437.method_25442()) {
                    lines.add(class_2561.method_43471((String)"item.cart.press_shift_tooltip").method_27692(class_124.field_1080));
                } else {
                    lines.add(class_2561.method_43471((String)("item." + cart.getCartType() + ".tooltip1")).method_27692(class_124.field_1080));
                    lines.add(class_2561.method_43471((String)("item." + cart.getCartType() + ".tooltip2")).method_27692(class_124.field_1080));
                }
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (actionKeyMapping.method_1436()) {
                ClientPlayNetworking.send((class_8710)new ActionKeyPayload());
            }
            class_746 player = client.field_1724;
            if (player != null) {
                while (toggleSlowMapping.method_1436()) {
                    if (player.method_49694() != null && ToggleSlowPayload.isSlowable(player.method_49694())) {
                        if (!ToggleSlowPayload.isSlow(player.method_49694())) {
                            player.method_7353((class_2561)class_2561.method_43469((String)"message.niftycarts.slow_toggled_on", (Object[])new Object[]{toggleSlowMapping.method_16007()}), true);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43469((String)"message.niftycarts.slow_toggled_off", (Object[])new Object[]{toggleSlowMapping.method_16007()}), true);
                        }
                    }
                    ClientPlayNetworking.send((class_8710)new ToggleSlowPayload());
                    class_304.method_1416((class_3675.class_306)toggleSlowMapping.method_1429(), (boolean)false);
                }
            }
            if (!client.method_1493() && client.field_1687 != null) {
                NiftyWorld.getClient().tick((class_1937)client.field_1687);
            }
        });
    }
}

