/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.NiftyCarts;
import net.jmb19905.niftycarts.NiftyCartsConfig;
import net.jmb19905.niftycarts.client.renderer.entity.CargoCartRenderState;
import net.jmb19905.niftycarts.client.renderer.entity.CargoRenderUtil;
import net.jmb19905.niftycarts.client.renderer.entity.DrawnRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.model.CargoCartModel;
import net.jmb19905.niftycarts.entity.AbstractCargoCart;
import net.jmb19905.niftycarts.util.NiftyItemUtil;
import net.minecraft.class_10034;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10197;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1087;
import net.minecraft.class_1304;
import net.minecraft.class_1535;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7406;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_811;
import net.minecraft.class_9334;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public abstract class CargoCartRenderer<T extends AbstractCargoCart, M extends CargoCartModel<CargoCartRenderState>>
extends DrawnRenderer<T, CargoCartRenderState, M> {
    private final class_572<class_10034> leggings;
    private final class_572<class_10034> armor;
    private final class_10197 equipmentRenderer;
    private final class_10442 itemModelResolver;
    private static final class_10034 humanoidRenderState = new class_10034();

    protected CargoCartRenderer(class_5617.class_5618 ctx, M model) {
        super(ctx, model);
        this.leggings = new class_572(ctx.method_32167(class_5602.field_27579));
        this.armor = new class_572(ctx.method_32167(class_5602.field_27580));
        this.field_4673 = 1.0f;
        this.equipmentRenderer = ctx.method_64072();
        this.itemModelResolver = ctx.method_65566();
    }

    @Override
    @NotNull
    public CargoCartRenderState createRenderState() {
        return new CargoCartRenderState();
    }

    @Override
    public void extractRenderState(T entity, CargoCartRenderState state, float delta) {
        super.extractRenderState(entity, state, delta);
        state.cargo = class_2371.method_10211();
        state.cargoStates = class_2371.method_10211();
        for (int i = 0; i < ((AbstractCargoCart)((Object)entity)).getCargo().size(); ++i) {
            state.cargo.add(i, (Object)((class_1799)((AbstractCargoCart)((Object)entity)).getCargo().get(i)));
            class_10444 cargoState = new class_10444();
            this.itemModelResolver.method_65595(cargoState, (class_1799)((AbstractCargoCart)((Object)entity)).getCargo().get(i), class_811.field_4315, entity);
            state.cargoStates.add(i, (Object)cargoState);
        }
        state.rngSeed = entity.method_5667().getMostSignificantBits() ^ entity.method_5667().getLeastSignificantBits();
        state.level = entity.method_37908();
    }

    @Override
    protected void renderContents(CargoCartRenderState state, class_4587 stack, class_4597 source, int packedLight) {
        class_1799 s;
        Contents contents = Contents.SUPPLIES;
        Iterator it = state.cargo.iterator();
        block6: while (it.hasNext()) {
            s = (class_1799)it.next();
            if (s.method_7960()) continue;
            for (Contents c : Contents.values()) {
                if (!c.predicate.test((class_1799)s)) continue;
                contents = c;
                break block6;
            }
        }
        while (contents != Contents.SUPPLIES && it.hasNext()) {
            s = (class_1799)it.next();
            if (s.method_7960() || contents.predicate.test((class_1799)s)) continue;
            contents = Contents.SUPPLIES;
            if (contents.predicate.test((class_1799)s)) continue;
            contents = Contents.NONE;
        }
        stack.method_22903();
        ((CargoCartModel)this.model).getBody().method_22703(stack);
        switch (contents.ordinal()) {
            case 0: {
                this.renderFlowers(state, stack, source, packedLight, state.cargo);
                break;
            }
            case 1: {
                this.renderPaintings(state, stack, source, packedLight, state.cargo);
                break;
            }
            case 2: {
                this.renderWheel(state, stack, source, packedLight);
                break;
            }
            case 3: {
                this.renderSupplies(state, stack, source, packedLight, state.cargo);
            }
        }
        if (state.bannerColor != null) {
            stack.method_22904(0.0, -0.6, 1.5);
            this.renderBanner(state, stack, source, packedLight);
        }
        stack.method_22909();
    }

    void renderFlowers(CargoCartRenderState state, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        ((CargoCartModel)this.model).getFlowerBasket().field_3665 = true;
        ((CargoCartModel)this.model).getFlowerBasket().method_22698(stack, source.getBuffer(((CargoCartModel)this.model).method_23500(this.getTextureLocation(state))), packedLight, class_4608.field_21444);
        ((CargoCartModel)this.model).getFlowerBasket().field_3665 = false;
        class_776 dispatcher = class_310.method_1551().method_1541();
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (!(itemStack.method_7909() instanceof class_1747)) continue;
            int ix = i % 2;
            int iz = i / 2;
            class_2680 defaultState = ((class_1747)itemStack.method_7909()).method_7711().method_9564();
            class_2680 blockState = defaultState.method_28498((class_2769)class_2741.field_12533) ? (class_2680)defaultState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609) : defaultState;
            class_1087 model = dispatcher.method_3349(blockState);
            int rgb = class_310.method_1551().method_1505().method_1697(blockState, null, null, 0);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            stack.method_22903();
            stack.method_22904(0.0, -0.7, this.getFlowerOffsetZ());
            stack.method_22905(0.65f, 0.65f, 0.65f);
            stack.method_22904((double)ix, 0.5, (double)iz - 1.0);
            stack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
            class_778.method_3367((class_4587.class_4665)stack.method_23760(), (class_4588)source.getBuffer(class_1921.method_23581()), (class_1087)model, (float)r, (float)g, (float)b, (int)packedLight, (int)class_4608.field_21444);
            stack.method_22909();
        }
    }

    private void renderWheel(CargoCartRenderState state, class_4587 stack, class_4597 source, int packedLight) {
        stack.method_22903();
        stack.method_61958(this.getWheelOffset());
        class_630 wheel = ((CargoCartModel)this.model).getWheel();
        wheel.field_3654 = 0.9f;
        wheel.field_3674 = 0.9424779f;
        wheel.method_22698(stack, source.getBuffer(((CargoCartModel)this.model).method_23500(this.getTextureLocation(state))), packedLight, class_4608.field_21444);
        stack.method_22909();
    }

    private void renderPaintings(CargoCartRenderState state, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        class_4588 buf = source.getBuffer(class_1921.method_23572((class_2960)class_310.method_1551().method_18321().method_18342().method_45852()));
        Random rng = new Random(state.rngSeed);
        int count = 0;
        for (class_1799 itemStack : cargo) {
            if (itemStack.method_7960()) continue;
            ++count;
        }
        stack.method_22903();
        stack.method_22904(0.0, -0.15625, 0.0);
        stack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
        class_5455 registryAccess = state.level.method_30349();
        ObjectArrayList variants = new ObjectArrayList();
        registryAccess.method_30530(class_7924.field_41209).method_40286(class_7406.field_38929).forEach(arg_0 -> CargoCartRenderer.lambda$renderPaintings$0((ObjectList)variants, arg_0));
        ObjectLists.shuffle((ObjectList)variants, (Random)rng);
        int n = 0;
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (itemStack.method_7960()) continue;
            class_6880 holder = (class_6880)itemStack.method_58694(class_9334.field_56138);
            class_1535 paintingVariant = null;
            if (holder != null) {
                paintingVariant = (class_1535)holder.comp_349();
            }
            if (paintingVariant == null || paintingVariant.method_59947() > 1) {
                if (variants.isEmpty()) continue;
                paintingVariant = (class_1535)variants.get(i % variants.size());
            }
            stack.method_22903();
            stack.method_61958(this.getPaintingOffset(i, n, count));
            ++n;
            stack.method_22907((Quaternionfc)class_7833.field_40718.rotation(rng.nextFloat() * (float)Math.PI * this.getPaintingAngleFactor()));
            CargoRenderUtil.renderPainting(paintingVariant, stack, buf, packedLight);
            stack.method_22909();
        }
        stack.method_22909();
    }

    protected boolean shouldRender(class_1799 stack) {
        ForgeConfigSpec.ConfigValue<ArrayList<String>> blacklist = NiftyCartsConfig.getClient().renderBlacklist;
        for (String item : (ArrayList)blacklist.get()) {
            class_6862 tag;
            if (!(item.startsWith("#") ? stack.method_31573(tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)item.substring(1)))) : item.equals(class_7923.field_41178.method_10221((Object)stack.method_7909()).toString()))) continue;
            return false;
        }
        return true;
    }

    private void renderSupplies(CargoCartRenderState state, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        Random rng = new Random();
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (itemStack.method_7960()) continue;
            int ix = i % 2;
            int iz = i / 2;
            if (i < cargo.size() - 2 && ((class_1799)cargo.get(i + 2)).method_31573(class_3489.field_16444) || i >= 2 && ((class_1799)cargo.get(i - 2)).method_31573(class_3489.field_16444)) continue;
            double x = this.getSuppliesOffsetX(ix);
            double z = this.getSuppliesOffsetZ(iz);
            stack.method_22903();
            class_10444 cargoState = (class_10444)state.cargoStates.get(i);
            if (this.shouldRender(itemStack)) {
                if (cargoState.method_65608() && itemStack.method_7909() != class_1802.field_8547 && ((Boolean)NiftyCartsConfig.getClient().renderSupplyGear.get()).booleanValue()) {
                    stack.method_22904(x, -0.46, z);
                    stack.method_22905(this.getBlockSize(), this.getBlockSize(), this.getBlockSize());
                    stack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
                    if (iz < 1 && itemStack.method_31573(class_3489.field_16444)) {
                        stack.method_22904(0.0, 0.0, 1.0);
                    }
                    cargoState.method_65604(stack, source, packedLight, class_4608.field_21444);
                } else {
                    rng.setSeed(32L * (long)i + (long)Objects.hashCode(class_7923.field_41178.method_10221((Object)itemStack.method_7909())));
                    stack.method_22904(x, -0.15 + ((ix + iz) % 2 == 0 ? 0.0 : 1.0E-4), z);
                    if (NiftyItemUtil.isHumanoidArmor(itemStack) && ((Boolean)NiftyCartsConfig.getClient().renderSupplyGear.get()).booleanValue()) {
                        stack.method_22905(this.getArmorSize(), this.getArmorSize(), this.getArmorSize());
                        this.renderArmor(stack, source, packedLight, itemStack, ix);
                    } else {
                        if (itemStack.method_7909() == class_1802.field_8255) {
                            stack.method_22905(this.getBlockSize(), this.getBlockSize(), this.getBlockSize());
                            stack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
                            stack.method_22905(1.2f, 1.2f, 1.2f);
                            stack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(ix == 0 ? -90.0f : 90.0f));
                            stack.method_22904(0.5, this.getShieldOffsetY(), -0.05);
                            stack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-22.5f));
                        } else {
                            stack.method_22905(this.getItemSize(), this.getItemSize(), this.getItemSize());
                            stack.method_22907((Quaternionfc)class_7833.field_40716.rotation(rng.nextFloat() * (float)Math.PI));
                            stack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
                        }
                        int copies = Math.min(itemStack.method_7947(), (itemStack.method_7947() - 1) / 16 + 2);
                        cargoState.method_65604(stack, source, packedLight, class_4608.field_21444);
                        for (int n = 1; n < copies; ++n) {
                            stack.method_22903();
                            stack.method_22907((Quaternionfc)class_7833.field_40718.rotation(rng.nextFloat() * (float)Math.PI));
                            stack.method_22904((double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), -0.1 * (double)n);
                            cargoState.method_65604(stack, source, packedLight, class_4608.field_21444);
                            stack.method_22909();
                        }
                    }
                }
            }
            stack.method_22909();
        }
    }

    private void renderArmor(class_4587 stack, class_4597 source, int packedLight, class_1799 itemStack, int ix) {
        class_10192 equippable = (class_10192)itemStack.method_58694(class_9334.field_54196);
        if (equippable == null) {
            return;
        }
        class_1304 slot = equippable.comp_3174();
        class_572<class_10034> m = slot == class_1304.field_6172 ? this.leggings : this.armor;
        stack.method_22907((Quaternionfc)class_7833.field_40716.rotation(ix == 0 ? 1.5707964f : -1.5707964f));
        m.method_2805(false);
        m.method_17087(humanoidRenderState);
        switch (slot) {
            case field_6169: {
                stack.method_22904(0.0, 0.1, 0.0);
                m.field_3398.field_3654 = 0.2f;
                m.field_3394.method_17138(m.field_3398);
                m.field_3398.field_3665 = true;
                m.field_3394.field_3665 = true;
                break;
            }
            case field_6174: {
                stack.method_22904(0.0, -0.4, -0.15);
                m.field_27433.field_3654 = -0.15f;
                m.field_3401.field_3654 = -0.15f;
                m.field_3391.field_3654 = 0.9f;
                m.field_3391.field_3665 = true;
                m.field_3401.field_3665 = true;
                m.field_27433.field_3665 = true;
                break;
            }
            case field_6172: {
                stack.method_22904(0.0, -0.7, -0.15);
                m.field_3391.field_3654 = 0.0f;
                m.field_3392.field_3654 = 1.2f;
                m.field_3397.field_3654 = 1.2f;
                m.field_3392.field_3675 = -0.3f;
                m.field_3397.field_3675 = 0.3f;
                m.field_3391.field_3665 = true;
                m.field_3392.field_3665 = true;
                m.field_3397.field_3665 = true;
                break;
            }
            case field_6166: {
                stack.method_22904(0.0, -1.15, -0.1);
                m.field_3392.field_3654 = 0.0f;
                m.field_3397.field_3654 = 0.0f;
                m.field_3392.field_3675 = -0.1f;
                m.field_3397.field_3675 = 0.0f;
                m.field_3392.field_3665 = true;
                m.field_3397.field_3665 = true;
            }
        }
        stack.method_22905(0.75f, 0.75f, 0.75f);
        class_5321 resourceLocation = (class_5321)equippable.comp_3176().orElseThrow();
        boolean usesInnerModel = slot == class_1304.field_6172;
        class_10186.class_10190 layerType = usesInnerModel ? class_10186.class_10190.field_54126 : class_10186.class_10190.field_54125;
        this.equipmentRenderer.method_64077(layerType, resourceLocation, m, itemStack, stack, source, packedLight);
    }

    protected abstract double getFlowerOffsetZ();

    protected abstract class_243 getWheelOffset();

    protected abstract class_243 getPaintingOffset(int var1, int var2, int var3);

    protected abstract float getPaintingAngleFactor();

    protected abstract double getSuppliesOffsetX(int var1);

    protected abstract double getSuppliesOffsetZ(int var1);

    protected abstract float getBlockSize();

    protected abstract float getArmorSize();

    protected abstract float getItemSize();

    protected abstract double getShieldOffsetY();

    private static /* synthetic */ void lambda$renderPaintings$0(ObjectList variants, class_6880 variantHolder) {
        if (((class_1535)variantHolder.comp_349()).method_59947() == 1) {
            variants.add((Object)((class_1535)variantHolder.comp_349()));
        }
    }

    static {
        CargoCartRenderer.humanoidRenderState.field_53410 = false;
        CargoCartRenderer.humanoidRenderState.field_53414 = false;
        CargoCartRenderer.humanoidRenderState.field_53412 = false;
    }

    @Environment(value=EnvType.CLIENT)
    private static enum Contents {
        FLOWERS(s -> s.method_7909() instanceof class_1747 && s.method_31573(class_3489.field_15543) && (Boolean)NiftyCartsConfig.getClient().renderSupplyFlowers.get() != false),
        PAINTINGS(s -> s.method_7909() == class_1802.field_8892 && (Boolean)NiftyCartsConfig.getClient().renderSupplyPaintings.get() != false),
        WHEEL(s -> s.method_7909() == NiftyCarts.WHEEL && (Boolean)NiftyCartsConfig.getClient().renderSupplyWheel.get() != false && (Boolean)NiftyCartsConfig.getClient().renderSupplies.get() != false),
        SUPPLIES(s -> (Boolean)NiftyCartsConfig.getClient().renderSupplies.get()),
        NONE(s -> true);

        private final Predicate<? super class_1799> predicate;

        private Contents(Predicate<? super class_1799> predicate) {
            this.predicate = predicate;
        }
    }
}

