/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity;

import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.client.mixin.ModelPartMixin;
import net.jmb19905.niftycarts.client.renderer.entity.CartRenderState;
import net.jmb19905.niftycarts.entity.AbstractDrawnEntity;
import net.minecraft.class_1088;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_823;
import net.minecraft.class_897;
import net.minecraft.class_9307;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public abstract class DrawnRenderer<T extends AbstractDrawnEntity, S extends CartRenderState, M extends class_583<S>>
extends class_897<T, S> {
    protected M model;
    private final class_630 flag;
    private final class_630 pole;
    private final class_630 bar;

    protected DrawnRenderer(class_5617.class_5618 renderManager, M model) {
        super(renderManager);
        this.model = model;
        class_630 banner = renderManager.method_32167(class_5602.field_27678);
        this.pole = banner.method_32086("pole");
        this.bar = banner.method_32086("bar");
        class_630 flag = renderManager.method_32167(class_5602.field_55122);
        this.flag = flag.method_32086("flag");
    }

    @NotNull
    public abstract S createRenderState();

    public void extractRenderState(T entity, S state, float delta) {
        super.method_62354(entity, state, delta);
        AbstractDrawnEntity.RenderInfo info = ((AbstractDrawnEntity)((Object)entity)).getInfo(delta);
        ((CartRenderState)((Object)state)).pitch = info.getPitch();
        ((CartRenderState)((Object)state)).yaw = info.getYaw();
        ((CartRenderState)((Object)state)).wheelRotation0 = ((AbstractDrawnEntity)((Object)entity)).getWheelRotation(0);
        ((CartRenderState)((Object)state)).wheelRotation1 = ((AbstractDrawnEntity)((Object)entity)).getWheelRotation(1);
        ((CartRenderState)((Object)state)).wheelRotationInc0 = ((AbstractDrawnEntity)((Object)entity)).getWheelRotationIncrement(0);
        ((CartRenderState)((Object)state)).wheelRotationInc1 = ((AbstractDrawnEntity)((Object)entity)).getWheelRotationIncrement(1);
        ((CartRenderState)((Object)state)).timeSinceHit = ((AbstractDrawnEntity)((Object)entity)).getTimeSinceHit();
        ((CartRenderState)((Object)state)).damage = ((AbstractDrawnEntity)((Object)entity)).getDamageTaken();
        ((CartRenderState)((Object)state)).forward = ((AbstractDrawnEntity)((Object)entity)).getForwardDirection();
        ((CartRenderState)((Object)state)).bannerColor = ((AbstractDrawnEntity)((Object)entity)).getBannerColor();
        ((CartRenderState)((Object)state)).bannerPattern = ((AbstractDrawnEntity)((Object)entity)).getBannerPattern();
        ((CartRenderState)((Object)state)).woodType = ((AbstractDrawnEntity)((Object)entity)).getWoodType();
    }

    public abstract class_2960 getTextureLocation(S var1);

    public void render(S state, class_4587 stack, class_4597 source, int light) {
        stack.method_22903();
        this.setupRotation(state, stack);
        this.model.method_2819(state);
        class_4588 buf = source.getBuffer(this.model.method_23500(this.getTextureLocation(state)));
        this.model.method_60879(stack, buf, light, class_4608.field_21444);
        this.renderContents(state, stack, source, light);
        stack.method_22909();
    }

    protected abstract void renderContents(S var1, class_4587 var2, class_4597 var3, int var4);

    public void setupRotation(S state, class_4587 stack) {
        stack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - ((CartRenderState)((Object)state)).yaw));
        float time = ((CartRenderState)((Object)state)).timeSinceHit - ((CartRenderState)((Object)state)).delta;
        if (time > 0.0f) {
            double center = 1.2;
            stack.method_22904(0.0, 1.2, 0.0);
            float damage = Math.max(((CartRenderState)((Object)state)).damage - ((CartRenderState)((Object)state)).delta, 0.0f);
            float angle = class_3532.method_15374((float)time) * time * damage / 60.0f;
            stack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(angle * (float)((CartRenderState)((Object)state)).forward));
            stack.method_22904(0.0, -1.2, 0.0);
            stack.method_22904(0.0, (double)(angle / 32.0f), 0.0);
        }
        stack.method_22905(-1.0f, -1.0f, 1.0f);
    }

    protected void renderBanner(S state, class_4587 stack, class_4597 source, int packedLight) {
        stack.method_22903();
        stack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
        float scale = 0.6666667f;
        stack.method_22905(0.6666667f, 0.6666667f, 0.6666667f);
        class_4588 consumer = class_1088.field_20847.method_24145(source, class_1921::method_23572);
        this.pole.field_3674 = -0.3f;
        this.pole.field_3657 = 17.48f;
        this.pole.field_3656 = 12.43f;
        this.pole.method_22698(stack, consumer, packedLight, class_4608.field_21444);
        this.bar.field_3657 = -4.0f;
        this.bar.field_3656 = 16.01f;
        this.bar.field_3655 = 0.01f;
        this.bar.method_22698(stack, consumer, packedLight, class_4608.field_21444);
        this.flag.field_3657 = -4.0f;
        this.flag.field_3656 = -26.0f;
        this.flag.field_3655 = 1.5f;
        float k = ((float)Math.floorMod((int)(((CartRenderState)((Object)state)).field_53325 * 7.0 + ((CartRenderState)((Object)state)).field_53326 * 9.0 + ((CartRenderState)((Object)state)).field_53327 * 13.0 + (double)((CartRenderState)((Object)state)).field_53328), 100) + ((CartRenderState)((Object)state)).delta) / 100.0f;
        this.flag.field_3654 = 0.01f * class_3532.method_15362((float)((float)Math.PI * 2 * k)) * (float)Math.PI;
        class_823.method_29999((class_4587)stack, (class_4597)source, (int)packedLight, (int)class_4608.field_21444, (class_630)this.flag, (class_4730)class_1088.field_20847, (boolean)true, (class_1767)((CartRenderState)((Object)state)).bannerColor, (class_9307)((CartRenderState)((Object)state)).bannerPattern);
        stack.method_22909();
    }

    protected void attach(class_630 bone, class_630 attachment, Consumer<class_4587> function, class_4587 stack) {
        stack.method_22903();
        bone.method_22703(stack);
        if (bone == attachment) {
            function.accept(stack);
        } else {
            Map<String, class_630> childModels = ((ModelPartMixin)bone).getChildren();
            for (class_630 child : childModels.values()) {
                this.attach(child, attachment, function, stack);
            }
        }
        stack.method_22909();
    }
}

