/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.client.renderer.NiftyCartsModelLayers;
import net.jmb19905.niftycarts.client.renderer.entity.DrawnRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.WagonRenderState;
import net.jmb19905.niftycarts.client.renderer.entity.model.WagonModel;
import net.jmb19905.niftycarts.entity.WagonEntity;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class WagonRenderer
extends DrawnRenderer<WagonEntity, WagonRenderState, WagonModel> {
    public WagonRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, new WagonModel(renderManager.method_32167(NiftyCartsModelLayers.WAGON), renderManager.method_32167(NiftyCartsModelLayers.WAGON_ROOF), renderManager.method_32167(NiftyCartsModelLayers.WAGON_CHEST)));
    }

    @Override
    public void extractRenderState(WagonEntity entity, WagonRenderState state, float delta) {
        super.extractRenderState(entity, state, delta);
        state.maxChestCount = entity.getMaxChestCount();
        state.chestCount = entity.getChestCount();
        state.hasRoof = entity.hasRoof();
        state.unfurled = entity.getUnfurled();
        state.roofTexture = entity.getRoofTexture();
    }

    @Override
    protected void renderContents(WagonRenderState state, class_4587 stack, class_4597 source, int packedLight) {
        stack.method_22903();
        ((WagonModel)this.model).getBody().method_22703(stack);
        stack.method_22903();
        for (int i = 0; i < state.maxChestCount; ++i) {
            ((WagonModel)this.model).getChest((int)i).field_3665 = i < state.chestCount;
        }
        ((WagonModel)this.model).getChests().method_22698(stack, source.getBuffer(((WagonModel)this.model).method_23500(class_2960.method_60655((String)"niftycarts", (String)"textures/entity/wagon_chest.png"))), packedLight, class_4608.field_21444);
        stack.method_22909();
        if (state.hasRoof) {
            ((WagonModel)this.model).getRoof(state.unfurled).method_22698(stack, source.getBuffer(((WagonModel)this.model).method_23500(state.roofTexture)), packedLight, class_4608.field_21444);
        }
        if (state.bannerColor != null) {
            stack.method_22903();
            stack.method_22904(0.0, -0.58, 2.62);
            this.renderBanner(state, stack, source, packedLight);
            stack.method_22909();
        }
        stack.method_22909();
    }

    @Override
    @NotNull
    public WagonRenderState createRenderState() {
        return new WagonRenderState();
    }

    @Override
    @NotNull
    public class_2960 getTextureLocation(WagonRenderState state) {
        return class_2960.method_60655((String)"niftycarts", (String)("textures/entity/" + state.woodType.comp_1299() + "_wagon.png"));
    }
}

