/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.client.renderer.entity.WagonRenderState;
import net.jmb19905.niftycarts.client.renderer.entity.model.CartModel;
import net.jmb19905.niftycarts.client.renderer.entity.model.EasyMeshBuilder;
import net.minecraft.class_3532;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class WagonModel
extends CartModel<WagonRenderState> {
    private static final float Z_FIGHTING_EPSILON = 0.001f;
    private final class_630 roof;
    private final class_630 chests;

    public WagonModel(class_630 root, class_630 roofRoot, class_630 chestRoot) {
        super(root, 2);
        this.roof = roofRoot.method_32086("roof");
        this.chests = chestRoot;
    }

    public class_630 getChests() {
        return this.chests;
    }

    public class_630 getChest(int idx) {
        return this.chests.method_32086("chest" + idx);
    }

    public class_630 getChestLid(int idx) {
        return this.getChest(idx).method_32086("chestLid");
    }

    public class_630 getRoof(int unfurl) {
        switch (unfurl) {
            case 0: {
                this.roof.method_32086((String)"roofUnfurled").field_3665 = true;
                this.roof.method_32086((String)"roofPartUnfurled").field_3665 = false;
                this.roof.method_32086((String)"roofFurled").field_3665 = false;
                break;
            }
            case 1: {
                this.roof.method_32086((String)"roofUnfurled").field_3665 = false;
                this.roof.method_32086((String)"roofPartUnfurled").field_3665 = true;
                this.roof.method_32086((String)"roofFurled").field_3665 = false;
                break;
            }
            default: {
                this.roof.method_32086((String)"roofUnfurled").field_3665 = false;
                this.roof.method_32086((String)"roofPartUnfurled").field_3665 = false;
                this.roof.method_32086((String)"roofFurled").field_3665 = true;
            }
        }
        return this.roof;
    }

    public static class_5607 createRoofLayer() {
        float axleLength = 35.0f;
        class_5609 def = new class_5609();
        EasyMeshBuilder roof = new EasyMeshBuilder("roof", 0, 0);
        roof.setRotationAngles(0.0f, 1.5707964f, 0.0f);
        EasyMeshBuilder roofTop = new EasyMeshBuilder("roofTop", 0, 0);
        roofTop.setRotationPoint(0.0f, -25.0f, 0.0f);
        roofTop.setRotationAngles(1.5707964f, 0.0f, 0.0f);
        roofTop.addBox(-32.002f, -axleLength / 2.0f + class_3532.method_15355((float)2.0f) * 8.0f, class_3532.method_15355((float)2.0f) * 8.0f - 2.0f, 24.0f, 35.0f - class_3532.method_15355((float)2.0f) * 16.0f, 2.0f);
        roofTop.addBox(8.002f, -axleLength / 2.0f + class_3532.method_15355((float)2.0f) * 8.0f, class_3532.method_15355((float)2.0f) * 8.0f - 2.0f, 24.0f, 35.0f - class_3532.method_15355((float)2.0f) * 16.0f, 2.0f);
        roofTop.addBox(-8.0f, -axleLength / 2.0f + 1.0f + class_3532.method_15355((float)112.5f), class_3532.method_15355((float)112.5f) - 1.0f, 16.0f, 33.0f - 2.0f * class_3532.method_15355((float)112.5f), 1.0f);
        roof.addChild(roofTop);
        EasyMeshBuilder roofUnfurled = new EasyMeshBuilder("roofUnfurled", 0, 0);
        roofUnfurled.addBox(-32.002f, -25.0f, -axleLength / 2.0f - 0.001f, 24.0f, 15.0f, 2.0f);
        roofUnfurled.addBox(-8.0f, -25.0f, -axleLength / 2.0f + 1.0f, 16.0f, 15.0f, 1.0f);
        roofUnfurled.addBox(8.002f, -25.0f, -axleLength / 2.0f - 0.001f, 24.0f, 15.0f, 2.0f);
        roofUnfurled.addBox(-32.002f, -25.0f, axleLength / 2.0f - 2.0f + 0.001f, 24.0f, 15.0f, 2.0f);
        roofUnfurled.addBox(-8.0f, -25.0f, axleLength / 2.0f - 2.0f, 16.0f, 15.0f, 1.0f);
        roofUnfurled.addBox(8.002f, -25.0f, axleLength / 2.0f - 2.0f + 0.001f, 24.0f, 15.0f, 2.0f);
        EasyMeshBuilder roofBackFlaps = new EasyMeshBuilder("roofBackFlaps", 0, 0);
        roofBackFlaps.setRotationAngles(0.0f, 1.5707964f, 0.0f);
        roofBackFlaps.addBox(-axleLength / 2.0f, -25.0f, -33.0f, 10.0f, 15.0f, 1.0f);
        roofBackFlaps.addBox(axleLength / 2.0f - 10.0f, -25.0f, -32.999f, 10.0f, 15.0f, 1.0f);
        roofBackFlaps.addBox(-axleLength / 2.0f + class_3532.method_15355((float)2.0f) * 8.0f, -25.0f - class_3532.method_15355((float)2.0f) * 8.0f, -33.002f, 35.0f - class_3532.method_15355((float)2.0f) * 16.0f, 10.0f, 1.0f);
        roofUnfurled.addChild(roofBackFlaps);
        EasyMeshBuilder roofBackFlapsAngledLeft = new EasyMeshBuilder("roofBackFlapsAngledLeft", 0, 0);
        roofBackFlapsAngledLeft.setRotationPoint(-axleLength / 2.0f, -25.0f, 0.0f);
        roofBackFlapsAngledLeft.setRotationAngles(0.0f, 0.0f, 0.7853982f);
        roofBackFlapsAngledLeft.addBox(0.0f, -16.0f, -33.001f, 10.0f, 16.0f, 1.0f);
        roofBackFlaps.addChild(roofBackFlapsAngledLeft);
        EasyMeshBuilder roofBackFlapsAngledRight = new EasyMeshBuilder("roofBackFlapsAngledRight", 0, 0);
        roofBackFlapsAngledRight.setRotationPoint(axleLength / 2.0f, -25.0f, 0.0f);
        roofBackFlapsAngledRight.setRotationAngles(0.0f, 0.0f, -0.7853982f);
        roofBackFlapsAngledRight.addBox(-10.0f, -16.0f, -33.0f, 10.0f, 16.0f, 1.0f);
        roofBackFlaps.addChild(roofBackFlapsAngledRight);
        EasyMeshBuilder roofFrontFlaps = new EasyMeshBuilder("roofFrontFlaps", 0, 0);
        roofFrontFlaps.setRotationAngles(0.0f, 1.5707964f, 0.0f);
        roofFrontFlaps.addBox(-axleLength / 2.0f, -25.0f, 32.0f, 10.0f, 15.0f, 1.0f);
        roofFrontFlaps.addBox(axleLength / 2.0f - 10.0f, -25.0f, 31.999f, 10.0f, 15.0f, 1.0f);
        roofFrontFlaps.addBox(-axleLength / 2.0f + class_3532.method_15355((float)2.0f) * 8.0f, -25.0f - class_3532.method_15355((float)2.0f) * 8.0f, 32.002f, 35.0f - class_3532.method_15355((float)2.0f) * 16.0f, 10.0f, 1.0f);
        roofUnfurled.addChild(roofFrontFlaps);
        EasyMeshBuilder roofFrontFlapsAngledLeft = new EasyMeshBuilder("roofFrontFlapsAngledLeft", 0, 0);
        roofFrontFlapsAngledLeft.setRotationPoint(-axleLength / 2.0f, -25.0f, 0.0f);
        roofFrontFlapsAngledLeft.setRotationAngles(0.0f, 0.0f, 0.7853982f);
        roofFrontFlapsAngledLeft.addBox(0.0f, -16.0f, 32.001f, 10.0f, 16.0f, 1.0f);
        roofFrontFlaps.addChild(roofFrontFlapsAngledLeft);
        EasyMeshBuilder roofFrontFlapsAngledRight = new EasyMeshBuilder("roofFrontFlapsAngledRight", 0, 0);
        roofFrontFlapsAngledRight.setRotationPoint(axleLength / 2.0f, -25.0f, 0.0f);
        roofFrontFlapsAngledRight.setRotationAngles(0.0f, 0.0f, -0.7853982f);
        roofFrontFlapsAngledRight.addBox(-10.0f, -16.0f, 32.0f, 10.0f, 16.0f, 1.0f);
        roofFrontFlaps.addChild(roofFrontFlapsAngledRight);
        EasyMeshBuilder roofLeftSlopeMiddle = new EasyMeshBuilder("roofLeftSlopeMiddle", 0, 0);
        roofLeftSlopeMiddle.setRotationPoint(0.0f, -25.0f, axleLength / 2.0f - 1.0f);
        roofLeftSlopeMiddle.setRotationAngles(0.7853982f, 0.0f, 0.0f);
        roofLeftSlopeMiddle.addBox(-8.0f, -15.0f, -1.0f, 16.0f, 15.0f, 1.0f);
        roofUnfurled.addChild(roofLeftSlopeMiddle);
        EasyMeshBuilder roofLeftSlopeOuter = new EasyMeshBuilder("roofLeftSlopeOuter", 0, 0);
        roofLeftSlopeOuter.setRotationPoint(0.0f, -25.0f, axleLength / 2.0f);
        roofLeftSlopeOuter.setRotationAngles(0.7853982f, 0.0f, 0.0f);
        roofLeftSlopeOuter.addBox(-32.0f, -16.0f, -2.0f, 24.0f, 16.0f, 2.0f);
        roofLeftSlopeOuter.addBox(8.0f, -16.0f, -2.0f, 24.0f, 16.0f, 2.0f);
        roofUnfurled.addChild(roofLeftSlopeOuter);
        EasyMeshBuilder roofRightSlopeMiddle = new EasyMeshBuilder("roofRightSlopeMiddle", 0, 0);
        roofRightSlopeMiddle.setRotationPoint(0.0f, -25.0f, -axleLength / 2.0f + 1.0f);
        roofRightSlopeMiddle.setRotationAngles(-0.7853982f, 0.0f, 0.0f);
        roofRightSlopeMiddle.addBox(-8.0f, -15.0f, 0.0f, 16.0f, 15.0f, 1.0f);
        roofUnfurled.addChild(roofRightSlopeMiddle);
        EasyMeshBuilder roofRightSlopeOuter = new EasyMeshBuilder("roofRightSlopeOuter", 0, 0);
        roofRightSlopeOuter.setRotationPoint(0.0f, -25.0f, -axleLength / 2.0f);
        roofRightSlopeOuter.setRotationAngles(-0.7853982f, 0.0f, 0.0f);
        roofRightSlopeOuter.addBox(-32.0f, -16.0f, 0.0f, 24.0f, 16.0f, 2.0f);
        roofRightSlopeOuter.addBox(8.0f, -16.0f, 0.0f, 24.0f, 16.0f, 2.0f);
        roofUnfurled.addChild(roofRightSlopeOuter);
        roof.addChild(roofUnfurled);
        EasyMeshBuilder roofPartUnfurled = new EasyMeshBuilder("roofPartUnfurled", 0, 0);
        roofPartUnfurled.addChild(roofLeftSlopeMiddle);
        roofPartUnfurled.addChild(roofLeftSlopeOuter);
        roofPartUnfurled.addChild(roofRightSlopeMiddle);
        roofPartUnfurled.addChild(roofRightSlopeOuter);
        roofPartUnfurled.addBox(-32.002f, -25.0f, -axleLength / 2.0f - 0.001f, 24.0f, 7.0f, 2.0f);
        roofPartUnfurled.addBox(-8.0f, -25.0f, -axleLength / 2.0f + 1.0f, 16.0f, 7.0f, 1.0f);
        roofPartUnfurled.addBox(8.002f, -25.0f, -axleLength / 2.0f - 0.001f, 24.0f, 7.0f, 2.0f);
        roofPartUnfurled.addBox(-32.002f, -20.0f, -axleLength / 2.0f - 0.001f - 1.0f, 24.0f, 2.0f, 1.0f);
        roofPartUnfurled.addBox(-8.0f, -20.0f, -axleLength / 2.0f, 16.0f, 2.0f, 1.0f);
        roofPartUnfurled.addBox(8.002f, -20.0f, -axleLength / 2.0f - 0.001f - 1.0f, 24.0f, 2.0f, 1.0f);
        roofPartUnfurled.addBox(-32.002f, -25.0f, axleLength / 2.0f - 2.0f + 0.001f, 24.0f, 7.0f, 2.0f);
        roofPartUnfurled.addBox(-8.0f, -25.0f, axleLength / 2.0f - 2.0f, 16.0f, 7.0f, 1.0f);
        roofPartUnfurled.addBox(8.002f, -25.0f, axleLength / 2.0f - 2.0f + 0.001f, 24.0f, 7.0f, 2.0f);
        roofPartUnfurled.addBox(-32.002f, -20.0f, axleLength / 2.0f + 0.001f, 24.0f, 2.0f, 1.0f);
        roofPartUnfurled.addBox(-8.0f, -20.0f, axleLength / 2.0f - 1.0f, 16.0f, 2.0f, 1.0f);
        roofPartUnfurled.addBox(8.002f, -20.0f, axleLength / 2.0f + 0.001f, 24.0f, 2.0f, 1.0f);
        EasyMeshBuilder roofBackFlapsPartUnfurled = new EasyMeshBuilder("roofBackFlapsPartUnfurled", 0, 0);
        roofBackFlapsPartUnfurled.setRotationAngles(0.0f, 1.5707964f, 0.0f);
        roofBackFlapsPartUnfurled.addBox(-axleLength / 2.0f, -25.0f, -33.0f, 10.0f, 7.0f, 1.0f);
        roofBackFlapsPartUnfurled.addBox(axleLength / 2.0f - 10.0f, -25.0f, -32.999f, 10.0f, 7.0f, 1.0f);
        roofBackFlapsPartUnfurled.addBox(-axleLength / 2.0f, -20.0f, -34.0f, 10.0f, 2.0f, 1.0f);
        roofBackFlapsPartUnfurled.addBox(axleLength / 2.0f - 10.0f, -20.0f, -33.999f, 10.0f, 2.0f, 1.0f);
        roofBackFlapsPartUnfurled.addBox(-axleLength / 2.0f + class_3532.method_15355((float)2.0f) * 8.0f, -25.0f - class_3532.method_15355((float)2.0f) * 8.0f, -33.002f, 35.0f - class_3532.method_15355((float)2.0f) * 16.0f, 10.0f, 1.0f);
        roofPartUnfurled.addChild(roofBackFlapsPartUnfurled);
        roofBackFlapsPartUnfurled.addChild(roofBackFlapsAngledLeft);
        roofBackFlapsPartUnfurled.addChild(roofBackFlapsAngledRight);
        EasyMeshBuilder roofFrontFlapsPartUnfurled = new EasyMeshBuilder("roofFrontFlapsPartUnfurled", 0, 0);
        roofFrontFlapsPartUnfurled.setRotationAngles(0.0f, 1.5707964f, 0.0f);
        roofFrontFlapsPartUnfurled.addBox(-axleLength / 2.0f, -25.0f, 32.0f, 10.0f, 7.0f, 1.0f);
        roofFrontFlapsPartUnfurled.addBox(axleLength / 2.0f - 10.0f, -25.0f, 31.999f, 10.0f, 7.0f, 1.0f);
        roofFrontFlapsPartUnfurled.addBox(-axleLength / 2.0f, -20.0f, 33.0f, 10.0f, 2.0f, 1.0f);
        roofFrontFlapsPartUnfurled.addBox(axleLength / 2.0f - 10.0f, -20.0f, 32.999f, 10.0f, 2.0f, 1.0f);
        roofFrontFlapsPartUnfurled.addBox(-axleLength / 2.0f + class_3532.method_15355((float)2.0f) * 8.0f, -25.0f - class_3532.method_15355((float)2.0f) * 8.0f, 32.002f, 35.0f - class_3532.method_15355((float)2.0f) * 16.0f, 10.0f, 1.0f);
        roofPartUnfurled.addChild(roofFrontFlapsPartUnfurled);
        roofFrontFlapsPartUnfurled.addChild(roofFrontFlapsAngledLeft);
        roofFrontFlapsPartUnfurled.addChild(roofFrontFlapsAngledRight);
        roof.addChild(roofPartUnfurled);
        EasyMeshBuilder furled = new EasyMeshBuilder("roofFurled", 0, 0);
        EasyMeshBuilder roofLeftSlopeMiddleFurled = new EasyMeshBuilder("roofLeftSlopeMiddleFurled", 0, 0);
        roofLeftSlopeMiddleFurled.setRotationPoint(0.0f, -25.0f, axleLength / 2.0f - 1.0f);
        roofLeftSlopeMiddleFurled.setRotationAngles(0.7853982f, 0.0f, 0.0f);
        roofLeftSlopeMiddleFurled.addBox(-8.0f, -15.0f, -1.0f, 16.0f, 5.0f, 1.0f);
        roofLeftSlopeMiddleFurled.addBox(-8.0f, -13.0f, 0.0f, 16.0f, 3.0f, 1.0f);
        furled.addChild(roofLeftSlopeMiddleFurled);
        EasyMeshBuilder roofLeftSlopeOuterFurled = new EasyMeshBuilder("roofLeftSlopeOuterFurled", 0, 0);
        roofLeftSlopeOuterFurled.setRotationPoint(0.0f, -25.0f, axleLength / 2.0f);
        roofLeftSlopeOuterFurled.setRotationAngles(0.7853982f, 0.0f, 0.0f);
        roofLeftSlopeOuterFurled.addBox(-32.0f, -16.0f, -2.0f, 24.0f, 6.0f, 2.0f);
        roofLeftSlopeOuterFurled.addBox(8.0f, -16.0f, -2.0f, 24.0f, 6.0f, 2.0f);
        roofLeftSlopeOuterFurled.addBox(-32.0f, -14.0f, 0.0f, 24.0f, 4.0f, 1.0f);
        roofLeftSlopeOuterFurled.addBox(8.0f, -14.0f, 0.0f, 24.0f, 4.0f, 1.0f);
        furled.addChild(roofLeftSlopeOuterFurled);
        EasyMeshBuilder roofRightSlopeMiddleFurled = new EasyMeshBuilder("roofRightSlopeMiddleFurled", 0, 0);
        roofRightSlopeMiddleFurled.setRotationPoint(0.0f, -25.0f, -axleLength / 2.0f + 1.0f);
        roofRightSlopeMiddleFurled.setRotationAngles(-0.7853982f, 0.0f, 0.0f);
        roofRightSlopeMiddleFurled.addBox(-8.0f, -15.0f, 0.0f, 16.0f, 5.0f, 1.0f);
        roofRightSlopeMiddleFurled.addBox(-8.0f, -13.0f, -1.0f, 16.0f, 3.0f, 1.0f);
        furled.addChild(roofRightSlopeMiddleFurled);
        EasyMeshBuilder roofRightSlopeOuterFurled = new EasyMeshBuilder("roofRightSlopeOuterFurled", 0, 0);
        roofRightSlopeOuterFurled.setRotationPoint(0.0f, -25.0f, -axleLength / 2.0f);
        roofRightSlopeOuterFurled.setRotationAngles(-0.7853982f, 0.0f, 0.0f);
        roofRightSlopeOuterFurled.addBox(-32.0f, -16.0f, 0.0f, 24.0f, 6.0f, 2.0f);
        roofRightSlopeOuterFurled.addBox(8.0f, -16.0f, 0.0f, 24.0f, 6.0f, 2.0f);
        roofRightSlopeOuterFurled.addBox(-32.0f, -14.0f, -1.0f, 24.0f, 4.0f, 1.0f);
        roofRightSlopeOuterFurled.addBox(8.0f, -14.0f, -1.0f, 24.0f, 4.0f, 1.0f);
        furled.addChild(roofRightSlopeOuterFurled);
        EasyMeshBuilder roofBackFlapsFurled = new EasyMeshBuilder("roofBackFlapsFurled", 0, 0);
        roofBackFlapsFurled.setRotationAngles(0.0f, 1.5707964f, 0.0f);
        roofBackFlapsFurled.addBox(-axleLength / 2.0f + class_3532.method_15355((float)2.0f) * 8.0f, -25.0f - class_3532.method_15355((float)2.0f) * 8.0f, -33.001f, 35.0f - class_3532.method_15355((float)2.0f) * 16.0f, 5.0f, 1.0f);
        roofBackFlapsFurled.addBox(-axleLength / 2.0f - 3.0f + class_3532.method_15355((float)2.0f) * 8.0f, -23.0f - class_3532.method_15355((float)2.0f) * 8.0f + 0.001f, -34.002f, 41.0f - class_3532.method_15355((float)2.0f) * 16.0f, 3.0f, 2.0f);
        furled.addChild(roofBackFlapsFurled);
        EasyMeshBuilder roofFrontFlapsFurled = new EasyMeshBuilder("roofFrontFlapsFurled", 0, 0);
        roofFrontFlapsFurled.setRotationAngles(0.0f, 1.5707964f, 0.0f);
        roofFrontFlapsFurled.addBox(-axleLength / 2.0f + class_3532.method_15355((float)2.0f) * 8.0f, -25.0f - class_3532.method_15355((float)2.0f) * 8.0f, 32.001f, 35.0f - class_3532.method_15355((float)2.0f) * 16.0f, 5.0f, 1.0f);
        roofFrontFlapsFurled.addBox(-axleLength / 2.0f - 3.0f + class_3532.method_15355((float)2.0f) * 8.0f, -23.0f - class_3532.method_15355((float)2.0f) * 8.0f + 0.001f, 32.002f, 41.0f - class_3532.method_15355((float)2.0f) * 16.0f, 3.0f, 2.0f);
        furled.addChild(roofFrontFlapsFurled);
        roof.addChild(furled);
        roof.build(def.method_32111());
        return class_5607.method_32110((class_5609)def, (int)16, (int)16);
    }

    public static class_5607 createLayer() {
        int rimLength = 10;
        float axleLength = 35.0f;
        float axleDist = 40.0f;
        class_5609 def = CartModel.createDefinition(rimLength, axleLength, 2, axleDist);
        EasyMeshBuilder axle0 = new EasyMeshBuilder("axle_0", 0, 60);
        axle0.addBox(-axleLength / 2.0f, -1.0f, -1.0f - axleDist / 2.0f, class_3532.method_15386((float)(axleLength / 2.0f)), 2.0f, 2.0f);
        axle0.addBox(-axleLength / 2.0f + (float)class_3532.method_15386((float)(axleLength / 2.0f)), -1.0f, -1.0f - axleDist / 2.0f, class_3532.method_15375((float)(axleLength / 2.0f)), 2.0f, 2.0f);
        EasyMeshBuilder axle1 = new EasyMeshBuilder("axle_1", 0, 60);
        axle1.addBox(-axleLength / 2.0f, -1.0f, -1.0f + axleDist / 2.0f, class_3532.method_15386((float)(axleLength / 2.0f)), 2.0f, 2.0f);
        axle1.addBox(-axleLength / 2.0f + (float)class_3532.method_15386((float)(axleLength / 2.0f)), -1.0f, -1.0f + axleDist / 2.0f, class_3532.method_15375((float)(axleLength / 2.0f)), 2.0f, 2.0f);
        EasyMeshBuilder base = new EasyMeshBuilder("base", 0, 0);
        base.addBox(-axleLength / 2.0f + 2.0f, -2.0f, -1.0f - axleDist / 2.0f - 10.0f, (float)Math.ceil((axleLength - 4.0f) / 2.0f), 1.0f, (axleDist + 22.0f) / 2.0f - 1.0f);
        base.addBox((float)((double)(-axleLength / 2.0f + 2.0f) + Math.ceil((axleLength - 4.0f) / 2.0f)), -2.0f, -1.0f - axleDist / 2.0f - 10.0f, (float)Math.floor((axleLength - 4.0f) / 2.0f), 1.0f, (axleDist + 22.0f) / 2.0f - 1.0f);
        base.addBox(-axleLength / 2.0f + 2.0f, -2.0f, -1.0f, (float)Math.ceil((axleLength - 4.0f) / 2.0f), 1.0f, (axleDist + 22.0f) / 2.0f + 1.0f);
        base.addBox((float)((double)(-axleLength / 2.0f + 2.0f) + Math.ceil((axleLength - 4.0f) / 2.0f)), -2.0f, -1.0f, (float)Math.floor((axleLength - 4.0f) / 2.0f), 1.0f, (axleDist + 22.0f) / 2.0f + 1.0f);
        EasyMeshBuilder walls = new EasyMeshBuilder("walls", 0, 0);
        EasyMeshBuilder rightWalls = new EasyMeshBuilder("rightWalls", 0, 2);
        rightWalls.setRotationAngles(0.0f, 1.5707964f, 0.0f);
        rightWalls.addBox(-32.0f, -10.0f, axleLength / 2.0f - 4.0f, 16.0f, 8.0f, 2.0f);
        rightWalls.addBox(-16.0f, -10.0f, axleLength / 2.0f - 4.0f, 16.0f, 8.0f, 2.0f);
        rightWalls.addBox(0.0f, -10.0f, axleLength / 2.0f - 4.0f, 16.0f, 8.0f, 2.0f);
        rightWalls.addBox(16.0f, -10.0f, axleLength / 2.0f - 4.0f, 16.0f, 8.0f, 2.0f);
        EasyMeshBuilder leftWalls = new EasyMeshBuilder("leftWalls", 0, 2);
        leftWalls.setRotationAngles(0.0f, -1.5707964f, 0.0f);
        leftWalls.addBox(-32.0f, -10.0f, axleLength / 2.0f - 4.0f, 16.0f, 8.0f, 2.0f);
        leftWalls.addBox(-16.0f, -10.0f, axleLength / 2.0f - 4.0f, 16.0f, 8.0f, 2.0f);
        leftWalls.addBox(0.0f, -10.0f, axleLength / 2.0f - 4.0f, 16.0f, 8.0f, 2.0f);
        leftWalls.addBox(16.0f, -10.0f, axleLength / 2.0f - 4.0f, 16.0f, 8.0f, 2.0f);
        EasyMeshBuilder wallBeams = new EasyMeshBuilder("wallBeams", 0, 3);
        wallBeams.setRotationAngles(0.0f, 1.5707964f, 0.0f);
        wallBeams.addBox(-32.0f, -10.0f, -axleLength / 2.0f + 1.0f, 4.0f, 8.0f, 1.0f);
        wallBeams.addBox(-12.0f, -10.0f, -axleLength / 2.0f + 1.0f, 4.0f, 8.0f, 1.0f);
        wallBeams.addBox(8.0f, -10.0f, -axleLength / 2.0f + 1.0f, 4.0f, 8.0f, 1.0f);
        wallBeams.addBox(28.0f, -10.0f, -axleLength / 2.0f + 1.0f, 4.0f, 8.0f, 1.0f);
        wallBeams.addBox(-32.0f, -10.0f, axleLength / 2.0f - 2.0f, 4.0f, 8.0f, 1.0f);
        wallBeams.addBox(-12.0f, -10.0f, axleLength / 2.0f - 2.0f, 4.0f, 8.0f, 1.0f);
        wallBeams.addBox(8.0f, -10.0f, axleLength / 2.0f - 2.0f, 4.0f, 8.0f, 1.0f);
        wallBeams.addBox(28.0f, -10.0f, axleLength / 2.0f - 2.0f, 4.0f, 8.0f, 1.0f);
        walls.addChild(wallBeams);
        walls.addChild(leftWalls);
        walls.addChild(rightWalls);
        EasyMeshBuilder beams = new EasyMeshBuilder("beams", 0, 32);
        beams.addBox(-axleLength / 2.0f + 2.0f, -25.0f, -32.002f, 1.0f, 15.0f, 4.0f);
        beams.addBox(-axleLength / 2.0f + 2.0f, -25.0f, -11.998f, 1.0f, 15.0f, 4.0f);
        beams.addBox(-axleLength / 2.0f + 2.0f, -25.0f, 7.998f, 1.0f, 15.0f, 4.0f);
        beams.addBox(-axleLength / 2.0f + 2.0f, -25.0f, 28.002f, 1.0f, 15.0f, 4.0f);
        beams.addBox(axleLength / 2.0f - 3.0f, -25.0f, -32.002f, 1.0f, 15.0f, 4.0f);
        beams.addBox(axleLength / 2.0f - 3.0f, -25.0f, -11.998f, 1.0f, 15.0f, 4.0f);
        beams.addBox(axleLength / 2.0f - 3.0f, -25.0f, 7.998f, 1.0f, 15.0f, 4.0f);
        beams.addBox(axleLength / 2.0f - 3.0f, -25.0f, 28.002f, 1.0f, 15.0f, 4.0f);
        walls.addChild(beams);
        EasyMeshBuilder backAndFrontWalls = new EasyMeshBuilder("backAndFront", 0, 3);
        backAndFrontWalls.addBox(-axleLength / 2.0f + 4.0f, -10.0f, -32.0f, axleLength - 8.0f, 8.0f, 1.0f);
        backAndFrontWalls.addBox(-axleLength / 2.0f + 4.0f, -10.0f, 31.0f, 8.0f, 8.0f, 1.0f);
        backAndFrontWalls.addBox(axleLength / 2.0f - 12.0f, -10.0f, 31.0f, 8.0f, 8.0f, 1.0f);
        walls.addChild(backAndFrontWalls);
        EasyMeshBuilder rotating = new EasyMeshBuilder("rotating", 0, 0);
        rotating.setRotationPoint(0.0f, -13.0f, -20.0f);
        rotating.addBox(-8.5f, 0.0f, -35.0f, 1.0f, 2.0f, 36.0f);
        rotating.addBox(7.5f, 0.0f, -35.0f, 1.0f, 2.0f, 36.0f);
        rotating.build(def.method_32111());
        EasyMeshBuilder wallLeft = new EasyMeshBuilder("beamsAngledLeft", 0, 32);
        wallLeft.setRotationPoint(axleLength / 2.0f - 2.0f, -25.0f, 0.0f);
        wallLeft.setRotationAngles(0.0f, 0.0f, -0.7853982f);
        wallLeft.addBox(-1.0f, -14.0f, -32.001f, 1.0f, 14.0f, 4.0f);
        wallLeft.addBox(-1.0f, -14.0f, -11.999f, 1.0f, 14.0f, 4.0f);
        wallLeft.addBox(-1.0f, -14.0f, 7.999f, 1.0f, 14.0f, 4.0f);
        wallLeft.addBox(-1.0f, -14.0f, 28.001f, 1.0f, 14.0f, 4.0f);
        walls.addChild(wallLeft);
        EasyMeshBuilder wallRight = new EasyMeshBuilder("beamsAngledRight", 0, 32);
        wallRight.setRotationPoint(-axleLength / 2.0f + 2.0f, -25.0f, 0.0f);
        wallRight.setRotationAngles(0.0f, 0.0f, 0.7853982f);
        wallRight.addBox(0.0f, -14.0f, -32.001f, 1.0f, 14.0f, 4.0f);
        wallRight.addBox(0.0f, -14.0f, -11.999f, 1.0f, 14.0f, 4.0f);
        wallRight.addBox(0.0f, -14.0f, 7.999f, 1.0f, 14.0f, 4.0f);
        wallRight.addBox(0.0f, -14.0f, 28.001f, 1.0f, 14.0f, 4.0f);
        walls.addChild(wallRight);
        EasyMeshBuilder wallTop = new EasyMeshBuilder("beamsTop", 3, 32);
        wallTop.setRotationPoint(0.0f, -25.0f, 0.0f);
        wallTop.setRotationAngles(1.5707964f, 1.5707964f, 0.0f);
        wallTop.addBox(-32.0f, -axleLength / 2.0f + 2.0f + class_3532.method_15355((float)2.0f) * 7.0f, (float)(Math.sqrt(2.0) * 7.0 - 1.0), 4.0f, 31.0f - class_3532.method_15355((float)2.0f) * 14.0f, 1.0f);
        wallTop.addBox(-12.0f, -axleLength / 2.0f + 2.0f + class_3532.method_15355((float)2.0f) * 7.0f, (float)(Math.sqrt(2.0) * 7.0 - 1.0), 4.0f, 31.0f - class_3532.method_15355((float)2.0f) * 14.0f, 1.0f);
        wallTop.addBox(8.0f, -axleLength / 2.0f + 2.0f + class_3532.method_15355((float)2.0f) * 7.0f, (float)(Math.sqrt(2.0) * 7.0 - 1.0), 4.0f, 31.0f - class_3532.method_15355((float)2.0f) * 14.0f, 1.0f);
        wallTop.addBox(28.0f, -axleLength / 2.0f + 2.0f + class_3532.method_15355((float)2.0f) * 7.0f, (float)(Math.sqrt(2.0) * 7.0 - 1.0), 4.0f, 31.0f - class_3532.method_15355((float)2.0f) * 14.0f, 1.0f);
        walls.addChild(wallTop);
        EasyMeshBuilder body = CartModel.createBody(rimLength);
        body.addChild(axle0);
        body.addChild(axle1);
        body.addChild(base);
        body.addChild(walls);
        body.build(def.method_32111());
        return class_5607.method_32110((class_5609)def, (int)64, (int)64);
    }

    public static class_5607 createChestLayer() {
        class_5609 def = new class_5609();
        EasyMeshBuilder backChest = new EasyMeshBuilder("chest0", 0, 0);
        backChest.setRotationPoint(0.0f, 0.0f, -31.0f);
        WagonModel.createChest(backChest);
        backChest.build(def.method_32111());
        EasyMeshBuilder middleChest = new EasyMeshBuilder("chest1", 0, 0);
        middleChest.setRotationPoint(0.0f, 0.0f, -15.0f);
        WagonModel.createChest(middleChest);
        middleChest.build(def.method_32111());
        EasyMeshBuilder frontChest = new EasyMeshBuilder("chest2", 0, 0);
        frontChest.setRotationPoint(0.0f, 0.0f, 1.0f);
        WagonModel.createChest(frontChest);
        frontChest.build(def.method_32111());
        return class_5607.method_32110((class_5609)def, (int)128, (int)64);
    }

    private static void createChest(EasyMeshBuilder root) {
        EasyMeshBuilder chestBottom = new EasyMeshBuilder("chestBottom", 0, 19);
        chestBottom.setRotationPoint(13.0f, -2.0f, 0.0f);
        chestBottom.setRotationAngles((float)Math.PI, (float)Math.PI, 0.0f);
        chestBottom.addBox(0.0f, 0.0f, 0.0f, 26.0f, 10.0f, 14.0f);
        root.addChild(chestBottom);
        EasyMeshBuilder chestLid = new EasyMeshBuilder("chestLid", 0, 0);
        chestLid.setRotationPoint(13.0f, -11.0f, 0.0f);
        chestLid.setRotationAngles((float)Math.PI, (float)Math.PI, 0.0f);
        chestLid.addBox(0.0f, 0.0f, 0.0f, 26.0f, 5.0f, 14.0f);
        root.addChild(chestLid);
        EasyMeshBuilder chestLock = new EasyMeshBuilder("chestLock", 0, 0);
        chestLock.setRotationPoint(14.0f, 3.0f, 14.0f);
        chestLock.setRotationAngles((float)Math.PI, (float)Math.PI, 0.0f);
        chestLock.addBox(0.0f, 0.0f, 0.0f, 2.0f, 4.0f, 1.0f);
        chestLid.addChild(chestLock);
    }
}

