/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.entity;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import net.jmb19905.niftycarts.entity.AbstractDrawnInventoryEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;

public abstract class AbstractCargoCart
extends AbstractDrawnInventoryEntity {
    private static final ImmutableList<class_2940<class_1799>> CARGO = ImmutableList.of((Object)class_2945.method_12791(AbstractCargoCart.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(AbstractCargoCart.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(AbstractCargoCart.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(AbstractCargoCart.class, (class_2941)class_2943.field_13322));

    public AbstractCargoCart(class_1299<? extends class_1297> entityTypeIn, class_1937 worldIn, int inventorySize) {
        super(entityTypeIn, worldIn, inventorySize);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        for (class_2940 parameter : CARGO) {
            builder.method_56912(parameter, (Object)class_1799.field_8037);
        }
    }

    public class_2371<class_1799> getCargo() {
        class_2371 cargo = class_2371.method_10213((int)CARGO.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < CARGO.size(); ++i) {
            cargo.set(i, (Object)((class_1799)this.field_6011.method_12789((class_2940)CARGO.get(i))));
        }
        return cargo;
    }

    @Override
    protected void onContentsChanged(int slot) {
        Object2IntLinkedOpenHashMap totals = new Object2IntLinkedOpenHashMap();
        Object2ObjectOpenHashMap stacks = new Object2ObjectOpenHashMap();
        for (int i = 0; i < this.method_42278().size(); ++i) {
            class_1799 stack = (class_1799)this.method_42278().get(i);
            if (stack.method_7960()) continue;
            totals.mergeInt((Object)stack.method_7909(), 1, Integer::sum);
            stacks.putIfAbsent((Object)stack.method_7909(), (Object)stack);
        }
        Iterator topTotals = totals.object2IntEntrySet().stream().sorted(Comparator.comparingInt(e -> e.getKey() instanceof class_1747 ? 0 : 1).thenComparingInt(e -> -e.getIntValue())).limit(CARGO.size()).iterator();
        Object[] items = new class_1799[CARGO.size()];
        Arrays.fill(items, class_1799.field_8037);
        int forth = this.method_42278().size() / CARGO.size();
        int pos = 0;
        while (topTotals.hasNext() && pos < CARGO.size()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)topTotals.next();
            int count = Math.max(1, (entry.getIntValue() + forth / 2) / forth);
            for (int n = 1; n <= count && pos < CARGO.size(); ++n) {
                class_1799 stack = ((class_1799)stacks.getOrDefault(entry.getKey(), (Object)class_1799.field_8037)).method_7972();
                stack.method_7939(Math.min(stack.method_7914(), entry.getIntValue() / n));
                items[pos++] = stack;
            }
        }
        for (int i = 0; i < CARGO.size(); ++i) {
            this.method_5841().method_12778((class_2940)CARGO.get(i), items[i]);
        }
    }

    @Override
    protected void saveInventory(class_11372 output) {
        this.method_42288(output);
    }

    @Override
    protected void readInventory(class_11368 input) {
        this.method_42285(input);
    }
}

